/*
 * Copyright (c) 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbget4int.c,v 1.5 2005/03/29 19:53:12 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/rcb.h"
#include "sm/reccom.h"

#define SM_GET_N	4

#if SM_USE_RCBV_INT2
/*
**  SM_RCB_GET4UINT32 -- Read four ints from the current position in a sm_rcb_P.
**
**	Parameters:
**		rcb -- sm_rcb_P object to read int from.
**		pv1 -- pointer to value to return.
**		pv2 -- pointer to value to return.
**		pv3 -- pointer to value to return.
**		pv4 -- pointer to value to return.
**
**	Returns:
**		usual sm_error code; SM_E_OVFLW_NS
**
**	Last code review: 2005-03-29 05:30:09
**	Last code change:
*/

sm_ret_T
sm_rcb_get4uint32(sm_rcb_P rcb, uint32_t *pv1, uint32_t *pv2, uint32_t *pv3, uint32_t *pv4)
{
	SM_IS_RCB(rcb);
# if SM_RCB_CHECK
	SM_REQUIRE(rcb->sm_rcb_state == SM_RCB_DEC);
# endif
# if PARANOID
	SM_REQUIRE(pv1 != NULL);
	SM_REQUIRE(pv2 != NULL);
	SM_REQUIRE(pv3 != NULL);
	SM_REQUIRE(pv4 != NULL);
	SM_REQUIRE(rcb->sm_rcb_base != NULL);
# endif
	if (rcb->sm_rcb_len < rcb->sm_rcb_rw + sizeof(uint32_t) * SM_GET_N)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	sm_buf2uint32(rcb->sm_rcb_base + rcb->sm_rcb_rw, pv1);
	rcb->sm_rcb_rw += sizeof(uint32_t);
	sm_buf2uint32(rcb->sm_rcb_base + rcb->sm_rcb_rw, pv2);
	rcb->sm_rcb_rw += sizeof(uint32_t);
	sm_buf2uint32(rcb->sm_rcb_base + rcb->sm_rcb_rw, pv3);
	rcb->sm_rcb_rw += sizeof(uint32_t);
	sm_buf2uint32(rcb->sm_rcb_base + rcb->sm_rcb_rw, pv4);
	rcb->sm_rcb_rw += sizeof(uint32_t);
	return SM_SUCCESS;
}
#endif /* SM_USE_RCBV_INT2 */
