/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbget3uint64.c,v 1.5 2005/03/29 19:53:12 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/rcb.h"
#include "sm/reccom.h"

/*
**  SM_RCB_GET3UINT64 -- Read two ints and one uint64 from a sm_rcb_P.
**
**	Parameters:
**		rcb -- sm_rcb_P object to read int from.
**		pv1 -- pointer to value to return.
**		pv2 -- pointer to value to return.
**		pu -- pointer to value to return.
**
**	Returns:
**		usual sm_error code; SM_E_OVFLW_NS
*/

sm_ret_T
sm_rcb_get3uint64(sm_rcb_P rcb, uint32_t *pv1, uint32_t *pv2, uint64_t *pu)
{
	SM_IS_RCB(rcb);
#if SM_RCB_CHECK
	SM_REQUIRE(rcb->sm_rcb_state == SM_RCB_DEC);
#endif
#if PARANOID
	SM_REQUIRE(pv1 != NULL);
	SM_REQUIRE(pv2 != NULL);
	SM_REQUIRE(pu != NULL);
	SM_REQUIRE(rcb->sm_rcb_base != NULL);
#endif
	if (rcb->sm_rcb_len < rcb->sm_rcb_rw + sizeof(uint32_t) * 2
				+ sizeof(uint64_t))
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	sm_buf2uint32(rcb->sm_rcb_base + rcb->sm_rcb_rw, pv1);
	rcb->sm_rcb_rw += sizeof(uint32_t);
	sm_buf2uint32(rcb->sm_rcb_base + rcb->sm_rcb_rw, pv2);
	rcb->sm_rcb_rw += sizeof(uint32_t);
	sm_buf2uint64(rcb->sm_rcb_base + rcb->sm_rcb_rw, pu);
	rcb->sm_rcb_rw += sizeof(uint64_t);
	return SM_SUCCESS;
}
