/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: putc.c,v 1.2 2005/01/17 21:35:22 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/str.h"
#include "io-int.h"

/*
**  SM_IO_PUTC -- add a character to the buffer for the file pointer
**
**	Parameters:
**		fp -- the file pointer for the buffer to be written to
**		ch -- character to be appended to the buffer
**
**	Returns:
**		usual sm_error code
**
**	Does this need checks for other types?
**	Is this function necessary at all or should the SMSTRSTR code
**	be fixed (to supply a write() function such that fflush() works)?
*/

sm_ret_T
sm_io_putc(sm_file_T *fp, int ch)
{
	sm_f_flags_T fl;
	sm_ret_T ret;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	if (cantwrite(fp))
		return sm_error_perm(SM_EM_IO, EBADF);

	fl = f_flags(*fp);
	if (fl & SMSTRSTR)
	{
		sm_str_P str;

		str = f_cookie(*fp);
		ret = SM_STR_PUT(str, ch);
	}
	else
	{
		ret = sm_putc(fp, ch);
	}
	return ret;
}
