/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: memcaseq.c,v 1.3 2004/05/18 05:40:43 ca Exp $")

#include "sm/assert.h"
#include "sm/ctype.h"
#include "sm/memops.h"

/*
**  SM_MEMCASEEQ -- Compare two memory regions (ignore case)
**
**	Parameters:
**		s1 -- pointer to first memory region
**		s2 -- pointer to second memory region
**		len -- length of memory regions (must be the same for both!)
**
**	Returns:
**		true iff the regions are identical (case insensitive)
*/

bool
sm_memcaseeq(const void *s1, const void *s2, size_t len)
{
	size_t i;
	uchar ch1, ch2;

	for (i = 0; i < len; i++)
	{
		ch1 = ((uchar *) s1)[i];
		ch2 = ((uchar *) s2)[i];
		if (ISUPPER(ch1))
			ch1 = tolower(ch1);
		if (ISUPPER(ch2))
			ch2 = tolower(ch2);
		if (ch1 != ch2)
			return false;
	}
	return true;
}

/*
**  SM_MEMNCASEEQ -- Compare two memory regions (ignore case)
**
**	Parameters:
**		s1 -- pointer to first memory region
**		l1 -- length of first memory region
**		s2 -- pointer to second memory region
**		l2 -- length of second memory region
**
**	Returns:
**		true iff the regions are identical (case insensitive)
*/

bool
sm_memncaseeq(const void *s1, size_t l1, const void *s2, size_t l2)
{
	if (l1 != l2)
		return false;
	return sm_memcaseeq(s1, s2, l1);
}
