/*
 * Copyright (c) 2000-2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: io-int.h,v 1.25 2005/06/17 20:34:43 ca Exp $
 */

#ifndef IO_INT_H
#define IO_INT_H 1

/*
**  Information local to this implementation of stdio,
**  in particular, macros and private variables.
*/

#include "sm/error.h"
#include "sm/time.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/rpool.h"
#include "sm/fcntl.h"

typedef	int (* sm_f_walk_F)(sm_file_T *);

sm_ret_T	 sm_init(void);

sm_ret_T	 sm_flush(sm_file_T *);
sm_file_T	*smfp(void);
int		 sm_refill(sm_file_T *);
void		 sm_cleanup(void);
sm_ret_T	 sm_makefilebuf(sm_file_T *);
int		 sm_fwalk(sm_f_walk_F);
sm_ret_T	 sm_wsetup(sm_file_T *);
sm_ret_T	 sm_fp(const sm_stream_T *, const sm_f_flags_T, sm_file_T *, sm_file_T **);
int		 sm_vprintf(char const *, va_list);
int		 sm_vfscanf(sm_file_T *, char const *, va_list);

sm_ret_T	sm_read_wait(int fd, int timeout);
sm_ret_T	sm_write_wait(int fd, int timeout);

/* std io functions */
read_F		 sm_stdread;
write_F		 sm_stdwrite;
seek_F		 sm_stdseek;
close_F		 sm_stdclose;
open_F		 sm_stdopen;
open_F		 sm_stdfdopen;
setinfo_F	 sm_stdsetinfo;
getinfo_F	 sm_stdgetinfo;

/* stdio io functions */
read_F		 sm_stdioread;
write_F		 sm_stdiowrite;
seek_F		 sm_stdioseek;
close_F		 sm_stdioclose;
open_F		 sm_stdioopen;
setinfo_F	 sm_stdiosetinfo;
getinfo_F	 sm_stdiogetinfo;

#if 0
/* string io functions */
read_F		 sm_strread;
write_F		 sm_strwrite;
seek_F		 sm_strseek;
close_F		 sm_strclose;
open_F		 sm_stropen;
open_F		 sm_strfdopen;
setinfo_F	 sm_strsetinfo;
getinfo_F	 sm_strgetinfo;
#endif /* 0 */

#if 0
/* syslog io functions */
read_F		 sm_syslogread;
write_F		 sm_syslogwrite;
seek_F		 sm_syslogseek;
close_F		 sm_syslogclose;
open_F		 sm_syslogopen;
open_F		 sm_syslogfdopen;
setinfo_F	 sm_syslogsetinfo;
getinfo_F	 sm_sysloggetinfo;
#endif /* 0 */

/* Return true iff the given sm_file_T cannot be written now. */
#define cantwrite(fp) \
	(((f_flags(*fp) & SMWR) == 0 || f_bfbase(*fp) == NULL) && \
	 sm_is_error(sm_wsetup(fp)))

#define SM_ALIGN(p)	(((ulong)(p) + SM_ALIGN_BITS) & ~SM_ALIGN_BITS)

#define sm_io_flockfile(fp)	((void) 0)
#define sm_io_funlockfile(fp)	((void) 0)

#if SM_DOUBLE_BUFFER
#define SM_IO_SAVE_BUF(fp, buffer) (fp)->buffer = f_bf(*fp)

#define SM_IO_TO_RD(fp) do						\
	{								\
		if (sm_io_double(fp) && ((f_flags(*fp) & SMRDBUF) == 0)) \
		{							\
			(fp)->f_wrbuf = f_bf(*fp);			\
			f_bf(*fp) = (fp)->f_rdbuf;			\
			f_flags(*fp) |= SMRDBUF;			\
			f_flags(*fp) &= ~SMWRBUF;			\
		}							\
		f_w(*fp) = 0;						\
	} while (0)

#define SM_IO_TO_WR(fp) do						\
	{								\
		if (sm_io_double(fp) && ((f_flags(*fp) & SMWRBUF) == 0)) \
		{							\
			(fp)->f_rdbuf = f_bf(*fp);			\
			f_bf(*fp) = (fp)->f_wrbuf;			\
			f_flags(*fp) |= SMWRBUF;			\
			f_flags(*fp) &= ~SMRDBUF;			\
		}							\
		f_r(*fp) = 0;						\
	} while (0)

#define SM_IO_CRT_DBUF(fp, buffer) do	\
	{					\
		(fp)->buffer = f_bf(*fp);	\
		(fp)->buffer.smb_base = (uchar *) 0;	\
		(fp)->buffer.smb_size = 0;	\
	} while (0)

#else /* SM_DOUBLE_BUFFER */

#define SM_IO_TO_RD(fp) f_w(*fp) = 0
#define SM_IO_TO_WR(fp) do \
	{					\
		f_r(*fp) = 0;			\
		f_p(*fp) = f_bfbase(*fp);	\
	} while (0)

#endif /* SM_DOUBLE_BUFFER */

#endif /* IO_INT_H */
