/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: id2idc.c,v 1.1 2004/04/02 00:24:47 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/mta.h"
#include "sm/io.h"

/*
**  SM_ID2IDC -- Extract id counter from session/transaction id
**
**	Parameters:
**		sessid -- session/transaction id
**		pidc -- (pointer to) id counter (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_id2idc(sessta_id_P sessid, id_count_T *pidc)
{
	int r;
	uchar c;

	SM_REQUIRE(pidc != NULL);
	c = sessid[SMTPS_STID_PID_OFF];
	sessid[SMTPS_STID_PID_OFF] = '\0';
	r = sm_io_sscanf(sessid + SMTPS_STID_IDC_OFF, "%qX", pidc);
	sessid[SMTPS_STID_PID_OFF] = c;
	if (r != 1)
		return sm_error_perm(SM_EM_Q_RDIBDB, EINVAL);
	return SM_SUCCESS;
}

