/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: getnextstring.c,v 1.3 2004/08/26 20:39:40 ca Exp $")

#include "sm/error.h"
#include "sm/assert.h"
#include "sm/ctype.h"
#include "sm/string.h"

/*
**  SM_GETNEXTSTR -- skip over whitespace in string, scan a string
**	(can be quoted; single/double quotes are allowed),
**	mark the end of the string with '\0'.
**
**	Parameters:
**		cpp -- (IN/OUT) pointer to string ('\0' terminated)
**
**	Returns:
**		new position in string (NULL on EOF)
**
**	Side Effects:
**		may modify string in place, i.e.,
**		replace trailing space with '\0'
**
**	Notes: this does not deal with "escaped" characters,
**		i.e,  (using angle brackets as delimiters)
**		< " 1\"  2"> will return the string <" 1\"> not <" 1\"  2">
**	Moreover, it requires a '\0' terminated string, it doesn't
**		provide length restrictions.
*/

char *
sm_getnextstring(char **cpp)
{
	char *cp, *start, quote;

	SM_REQUIRE(cpp != NULL);
	cp = *cpp;
	if (cp == NULL)
		return NULL;
	while (*cp != '\0' && ISSPACE(*cp))
		cp++;
	if (*cp == '\0')
	{
		*cpp = NULL;
		return NULL;
	}
	if (*cp == '"' || *cp == '\'')
		quote = *cp++;
	else
		quote = '\0';

	start = cp;
	if (quote != '\0')
	{
		while (*cp != '\0' && *cp != quote)
			cp++;
	}
	else
	{
		while (*cp != '\0' && !ISSPACE(*cp))
			cp++;
	}
	if (*cp != '\0')
		*cp++ = '\0';
	*cpp = cp;
	return start;
}
