/*
 * Copyright (c) 2000-2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fscanf.c,v 1.6 2005/01/27 00:29:17 ca Exp $")
#include "sm/varargs.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "io-int.h"

/*
**  SM_IO_FSCANF -- convert input data to translated format
**
**	Parameters:
**		fp -- the file pointer to obtain the data from
**		fmt -- the format to translate the data to
**		... -- memory locations to place the formated data
**
**	Returns:
**		Failure: returns SM_IO_EOF
**		Success: returns the number of data units translated
*/

/* SCANFLIKE2 */
int
sm_io_fscanf(sm_file_T *fp, char const *fmt, ...)
{
	int ret;
	va_list ap;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	va_start(ap, fmt);
	ret = sm_vfscanf(fp, fmt, ap);
	va_end(ap);
	return ret;
}
