/*
 * Copyright (c) 2000-2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fprintf.c,v 1.7 2005/01/27 00:29:17 ca Exp $")
#include "sm/varargs.h"
#include "sm/io.h"
#include "sm/assert.h"
#include "io-int.h"

/*
**  SM_IO_FPRINTF -- format and print a string to a file pointer
**
**	Parameters:
**		fp -- file pointer to be printed to
**		timeout -- time to complete print
**		fmt -- markup format for the string to be printed
**		... -- additional information for 'fmt'
**
**	Returns:
**		Failure: returns SM_IO_EOF and sets errno
**		Success: returns the number of characters o/p
*/

/* PRINTFLIKE2 */
int
sm_io_fprintf(sm_file_T *fp, const char *fmt, ...)
{
	int ret;
	va_list ap;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	va_start(ap, fmt);
	ret = sm_io_vfprintf(fp, fmt, ap);
	va_end(ap);
	return ret;
}
