/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: ffill.c,v 1.4 2005/03/15 19:56:07 ca Exp $")
#include <stdlib.h>
#include <string.h>
#include "sm/io.h"
#include "sm/assert.h"
#include "io-int.h"

/*
**  SM_IO_FFILL -- make sure that at least n chars are in file buffer
**
**	Notice: this requires that the buffer size is a multiple of n
**
**	Parameters:
**		fp -- the file to read from
**		n -- size
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_io_ffill(sm_file_T *fp, size_t n)
{
	int len;
	sm_ret_T ret;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);

	/* If the buffer is empty, refill it. */
	if ((len = f_r(*fp)) <= 0)
	{
		ret = sm_refill(fp);
		if (sm_is_err(ret))
			return ret;
		len = f_r(*fp);
	}
	if ((size_t) len < n)
		return sm_error_perm(SM_EM_IO, EIO);
	return SM_SUCCESS;
}
