/*
 * Copyright (c) 2002, 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: cstrfree.c,v 1.8 2005/07/12 23:23:38 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/heap.h"
#include "sm/limits.h"
#include "sm/cstr.h"

/*
**  SM_CSTR_FREE -- Frees a cstring
**
**	Parameters:
**		cstr -- cstring to free
**
**	Returns:
**		none.
*/

void
sm_cstr_free(sm_cstr_P cstr)
{
	SM_IS_CSTR(cstr);
	SM_CSTR_LOCK(cstr);
	SM_ASSERT(cstr->sm_cstr_refcnt > 0);
	if (--cstr->sm_cstr_refcnt > 0)
	{
		SM_CSTR_UNLOCK(cstr);
		return;
	}
	SM_CSTR_UNLOCK(cstr);
	if (cstr->sm_cstr_base != NULL)
		sm_free_size(cstr->sm_cstr_base, cstr->sm_cstr_len);
#if SM_USE_PTHREADS
	pthread_mutex_destroy(&(cstr->sm_cstr_mutex));
#endif /* SM_USE_PTHREADS */
	sm_free_size(cstr, sizeof(*cstr));
}
