/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: log.h,v 1.4 2005/06/16 00:39:05 ca Exp $
 */

#ifndef LIBEVTHR_LOG_H
#define LIBEVTHR_LOG_H 1

#include "sm/generic.h"
#include "sm/log.h"

#if LIBEVTHR_LOG_DEFINES
sm_logcategory_T evthr_lcats[] =
{
	{ "init",	0 },
	{ "eventloop",	0 },
	{ "signal",	0 },
	{ "worker",	0 },
	{ NULL,	0 }
};

sm_logmodule_T evthr_lmods[] =
{
	{ "evthr/init",	0 },
	{ "evthr/eventloop",	0 },
	{ "evthr/signal",	0 },
	{ "evthr/accept",	0 },
	{ "evthr/worker",	0 },
	{ NULL,		0 }
};

#else /* LIBEVTHR_LOG_DEFINES */

extern sm_logcategory_T evthr_lcats[];
extern sm_logmodule_T evthr_lmods[];

#endif /* LIBEVTHR_LOG_DEFINES */

#define EVTHR_LCAT_INIT		(&evthr_lcats[0])
#define EVTHR_LCAT_EVLOOP	(&evthr_lcats[1])
#define EVTHR_LCAT_SIGNAL	(&evthr_lcats[2])
#define EVTHR_LCAT_WORKER	(&evthr_lcats[3])

/* Backwards compatibility. */
#define EVTHR_LCAT_GENERAL	SM_LOGCATEGORY_GENERAL

#define EVTHR_LMOD_INIT		(&evthr_lmods[0])
#define EVTHR_LMOD_EVLOOP	(&evthr_lmods[1])
#define EVTHR_LMOD_SIGNAL	(&evthr_lmods[2])
#define EVTHR_LMOD_ACCEPT	(&evthr_lmods[3])
#define EVTHR_LMOD_WORKER	(&evthr_lmods[4])

#if 0
void	 evthr_log_init(sm_log_ctx_P _lctx);
void	 evthr_log_setcontext(sm_log_ctx_P _lctx);
#endif

#endif /* LIBEVTHR_LOG_H */
