/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-nameok.c,v 1.5 2004/12/26 04:08:58 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/test.h"
#include "sm/string.h"
#include "nameok.h"
#include <stdio.h>

static void
test(void)
{
	uchar c;
	uchar h[256];

	SM_TEST(validdnsdomain((const uchar *) "a", 0));
	SM_TEST(validdnsdomain((const uchar *) "1", 0));
	SM_TEST(validdnsdomain((const uchar *) "a.", 0));
	SM_TEST(validdnsdomain((const uchar *) "2.", 0));
	SM_TEST(validdnsdomain((const uchar *) "a.b", 0));
	SM_TEST(validdnsdomain((const uchar *) "a.b.c", 0));
	SM_TEST(!validdnsdomain((const uchar *) ".", 0));
	SM_TEST(!validdnsdomain((const uchar *) "..", 0));
	SM_TEST(!validdnsdomain((const uchar *) "..b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a..b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a.b..", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a.b-.", 0));
	SM_TEST(!validdnsdomain((const uchar *) "_", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a_", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a_b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "-", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a-", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a-.", 0));
	SM_TEST(validdnsdomain((const uchar *) "a-b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "-.", 0));
	SM_TEST(!validdnsdomain((const uchar *) ".-", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a-.", 0));
	SM_TEST(validdnsdomain((const uchar *) "a-b.", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a--b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a-.-b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllla", 0));
	SM_TEST(validdnsdomain((const uchar *) "llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll", 0));
	SM_TEST(validdnsdomain((const uchar *) "llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll.llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll.llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll.llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll", 0));
	SM_TEST(!validdnsdomain((const uchar *) "llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll.llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll.llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll.llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll.a", 0));

	SM_TEST(!validdnsdomain((const uchar *) "_", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a_", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a_b", 0));

	SM_TEST(!validdnsdomain((const uchar *) "!", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a!", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a!b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "%", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a%", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a%b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "$", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a$", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a$b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "*", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a*", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a*b", 0));
	SM_TEST(!validdnsdomain((const uchar *) "(", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a(", 0));
	SM_TEST(!validdnsdomain((const uchar *) "a(b", 0));

	for (c = '!'; c < '0'; c++)
	{
		if (c == '.' || c == '-')
			continue;
		sm_snprintf((char *)h, sizeof(h), "%c", c);
		SM_TEST(!validdnsdomain(h, 0));
		sm_snprintf((char *)h, sizeof(h), "a%c", c);
		SM_TEST(!validdnsdomain(h, 0));
		sm_snprintf((char *)h, sizeof(h), "a%cb", c);
		SM_TEST(!validdnsdomain(h, 0));
	}

	for (c = '['; c < '`'; c++)
	{
		sm_snprintf((char *)h, sizeof(h), "%c", c);
		SM_TEST(!validdnsdomain(h, 0));
		sm_snprintf((char *)h, sizeof(h), "a%c", c);
		SM_TEST(!validdnsdomain(h, 0));
		sm_snprintf((char *)h, sizeof(h), "a%cb", c);
		SM_TEST(!validdnsdomain(h, 0));
	}

	for (c = '{'; c < 255; c++)
	{
		sm_snprintf((char *)h, sizeof(h), "%c", c);
		SM_TEST(!validdnsdomain(h, 0));
		sm_snprintf((char *)h, sizeof(h), "a%c", c);
		SM_TEST(!validdnsdomain(h, 0));
		sm_snprintf((char *)h, sizeof(h), "a%cb", c);
		SM_TEST(!validdnsdomain(h, 0));
	}

	c = 255;
	sm_snprintf((char *)h, sizeof(h), "%c", c);
	SM_TEST(!validdnsdomain(h, 0));
	sm_snprintf((char *)h, sizeof(h), "a%c", c);
	SM_TEST(!validdnsdomain(h, 0));
	sm_snprintf((char *)h, sizeof(h), "a%cb", c);
	SM_TEST(!validdnsdomain(h, 0));

	SM_TEST(validdnsdomain((const uchar *) "a--b", DNS_HYPHENS));
	SM_TEST(!validdnsdomain((const uchar *) "a--", DNS_HYPHENS));

	SM_TEST(validdnsdomain((const uchar *) "_", DNS__OK));
	SM_TEST(validdnsdomain((const uchar *) "a_", DNS__OK));
	SM_TEST(validdnsdomain((const uchar *) "a_b", DNS__OK));

	return;
}

int
main(int argc, char *argv[])
{
	int i, c;
	uint flags;
	bool b;

	flags = 0;
	while ((c = getopt(argc, argv, "f:")) != -1)
	{
		switch (c)
		{
		  case 'f':
			flags = (uint) atoi(optarg);
			break;
		  default:
/*
			usage(argv[0]);
*/
			return 1;
		}
	}

	argc -= optind;
	argv += optind;
	sm_test_begin(argc, argv, "test nameok");
	if (argc > 0)
	{
		for (i = 0; i < argc; i++)
		{
			b = validdnsdomain((const uchar *) argv[i], flags);
			fprintf(stderr, "validdnsdomain(%s)=%s\n", argv[i],
				b ? "true" : "false");
		}
	}
	else
		test();
	return sm_test_end();
}
