#!/bin/sh
# $Id: t-dns-1.sh,v 1.11 2005/10/17 02:16:03 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# run t-dnstsk-1 with various parameters/arguments, esp. CNAME handling.
# depends on sm9.org DNS data.
# ----------------------------------------
#
test -s stop && exit 1

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../
fi
GETNS=${SD}/../misc/getns.sh
if test -x ${GETNS}
then
  . ${GETNS}
else
NS=`grep '^nameserver' /etc/resolv.conf | head -1 | sed -e 's/nameserver[	 ]*\([0-9][0-9\.]*\).*$/\1/'`
fi
if test -z "${NS}"
then
  echo "$0: no nameserver found"
  exit 0
fi

ERRS=0
OPTS="-Vam"
OUT=t-dns-1.out
OK=t-dns-1.ok
TPRG=./t-dnstsk-1

if test X"${SM_DNS_TIMEOUT}" != "X"
then
  OPTS="${OPTS} -O ${SM_DNS_TIMEOUT}"
fi

cat > ${OK} <<EOF
IPv4=7F000001
EOF

for NAME in cname1.sm9.org cname2cname1.sm9.org cname3cname2.sm9.org cname4cname3.sm9.org
do
if ${TPRG} ${OPTS} $@ -i ${NS} ${NAME} 2>&1 | grep IPv4 > ${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    echo "$0: test failed for ${NAME}"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  echo "$0: ${TPRG} failed for ${NAME}"
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
done

# 2004-05-17
# seems newer bind resolvers don't like this...
# cat > ${OK} <<EOF
# DNSR_TEMP
# EOF
# if ${TPRG} ${OPTS} $@ -i ${NS} cname2itself.sm9.org 2>&1 | egrep 'IPv4|DNSR|CNAME' > ${OUT}
# then
#   if diff ${OK} ${OUT}
#   then
#     :
#   else
#     ERRS=`expr ${ERRS} + 1 `
#     test X"${SM_STOPONERROR}" != X && exit ${ERRS}
#   fi
# else
#   ERRS=`expr ${ERRS} + 1 `
#   test X"${SM_STOPONERROR}" != X && exit ${ERRS}
# fi

cat > ${OK} <<EOF
DNSR_TEMP
EOF
NAME=cnameloop1.sm9.org
if ${TPRG} ${OPTS} $@ -i ${NS} ${NAME} 2>&1 | egrep 'IPv4|DNSR|CNAME' > ${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    echo "$0: test failed for ${NAME}"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  echo "$0: ${TPRG} failed for ${NAME}"
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

cat > ${OK} <<EOF
DNSR_NOTFOUND
DNSR_NOTFOUND
EOF
NAME="mxip.sm9.org mxip2.sm9.org"
if ${TPRG} ${OPTS} $@ -i ${NS} ${NAME} 2>&1 | egrep 'IPv4|DNSR|CNAME' > ${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    echo "$0: test failed for ${NAME}"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  echo "$0: ${TPRG} failed for ${NAME}"
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi


exit ${ERRS}
