/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: version.h,v 1.15 2005/08/30 17:51:30 ca Exp $
 */

#ifndef SM_VERSION_H
#define SM_VERSION_H 1

#include "sm/generic.h"

#if SMX_VERSION_OVERRIDE

/* see configure.ac for relationship between SMX_TYPE and SMX_TYPE_N */
#define SMX_MAJOR	0
#define SMX_MINOR	0
#define SMX_TYPE_N	2
#if SMX_TYPE_N == 0
#define SMX_TYPE	PreAlpha
#elif SMX_TYPE_N == 1
#define SMX_TYPE	Alpha
#elif SMX_TYPE_N == 2
#define SMX_TYPE	Beta
#elif SMX_TYPE_N == 2
#define SMX_TYPE	Gamma
#else
#define SMX_TYPE	
#endif
#define SMX_TYPEVERSION	1
#define SMX_LEVEL	0

#else /* SMX_VERSION_OVERRIDE */

/* 6 bit */
#ifndef SMX_MAJOR
#define SMX_MAJOR	0
#endif

/* 7 bit */
#ifndef SMX_MINOR
#define SMX_MINOR	0
#endif

#ifndef SMX_TYPE
#define SMX_TYPE	Alpha
#endif

/* 3 bit */
#ifndef SMX_TYPE_N
#define SMX_TYPE_N	0
#endif

/* 8 bit */
#ifndef SMX_TYPEVERSION
#define SMX_TYPEVERSION	1
#endif

/* 8 bit */
#ifndef SMX_LEVEL
#define SMX_LEVEL	0
#endif

#endif /* SMX_VERSION_OVERRIDE */

#define SMX_VERSION_STR	"sendmail X." SM_XSTR(SMX_MAJOR) "." SM_XSTR(SMX_MINOR) "." SM_XSTR(SMX_TYPE) SM_XSTR(SMX_TYPEVERSION) "." SM_XSTR(SMX_LEVEL)

#define SMX_VERSION	(((SMX_MAJOR) << 26) + ((SMX_MINOR) << 19) + ((SMX_TYPE_N) << 16) + ((SMX_TYPEVERSION) << 8) + (SMX_LEVEL))

#endif /* SM_VERSION_H */
