/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: unixsock.h,v 1.10 2005/06/16 00:09:35 ca Exp $
 */

#ifndef SM_UNIXSOCK_H
#define SM_UNIXSOCK_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/net.h"

typedef struct sockaddr_un sockaddr_un_T, *sockaddr_un_P;

sm_ret_T unix_server_listen_addr(sockaddr_un_T *_my_addr, socklen_T _addrlen, int _backlog);
sm_ret_T unix_server_listen(const char *_name, int _backlog);
sm_ret_T unix_server_accept(int _listenfd, sockaddr_T *_addr, sockaddr_len_T *_addrlen);
sm_ret_T unix_client_connect(const char *_name, int *_pfd);

#define unix_socket_close(sock)	close(sock)


#if 0
sm_ret_T unix_socket_create(int _fd);
ssize_t	unix_out(int _fd, const uchar *_src, size_t _len);
#endif

#endif /* SM_UNIXSOCK_H */
