/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: rsc-int.h,v 1.9 2005/09/29 17:17:50 ca Exp $
 */

/*
**  This file may be included multiple times! Do NOT protect against that.
*/

#include "sm/types.h"
#include "sm/error.h"
#if SM_USE_PTHREADS
# include "sm/pthread.h"
#endif

/* struct "hidden" in rsc.c */
typedef struct sm_rsc_S sm_rsc_T, *sm_rsc_P;

/* function types to create/delete an entry */
typedef void	*(*sm_rsc_create_F) (const char *_key, uint _len, void *_value,
			void *_ctx
#if SM_RSC_TYPED
			, uint _type
#endif
			);
typedef sm_ret_T (*sm_rsc_delete_F) (void *_value, void *_ctx
#if SM_RSC_TYPED
			, uint _type
#endif
			);

/* function type to apply to all entries in cache */
typedef void (sm_rsc_walk_F)(const char * _key, const void * _value, void *_rsc_ctx, void *_ctx
#if SM_RSC_TYPED
				, uint _type
#endif
			);

sm_rsc_P	 sm_rsc_new(uint _limit,
				uint _htsize,
				sm_rsc_create_F _create,
				sm_rsc_delete_F _delete,
				void *_context);
void		 sm_rsc_free(sm_rsc_P _rsc);
sm_ret_T	 sm_rsc_walk(sm_rsc_P _rsc, sm_rsc_walk_F *_f, void *_ctx
#if SM_USE_PTHREADS
				, thr_lock_T _locktype
#endif
				);
sm_ret_T	 sm_rsc_add(sm_rsc_P _rsc, bool _delok,
#if SM_RSC_TYPED
				uint _type,
#endif
				char *_key,
				uint _len,
				void *_value,
				void **_pvalue
#if SM_USE_PTHREADS
				, thr_lock_T _locktype
#endif
				);
const void	*sm_rsc_lookup(sm_rsc_P _cache, const char *_key, uint _len
#if SM_USE_PTHREADS
				, thr_lock_T _locktype
#endif
				);
sm_ret_T	 sm_rsc_rm(sm_rsc_P _rsc, const char *_key, uint _len
#if SM_USE_PTHREADS
				, thr_lock_T _locktype
#endif
				);
uint	 sm_rsc_usage(sm_rsc_P _rsc);
uint	 sm_rsc_entries(sm_rsc_P _rsc, uint *_pmax_used);
void	 sm_rsc_stats(sm_rsc_P _rsc, char *_out, uint _len);

