/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: qmgrcnfdef.h,v 1.54 2005/09/18 05:54:00 ca Exp $
 */

#ifndef SM_QMGRCNFDEF_H
#define SM_QMGRCNFDEF_H 1

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/cnf.h"
#include "sm/edbdef.h"
#include "sm/qmgrcto.h"
#include "sm/qmgrdef.h"
#include "sm/qmgrcnf.h"
#include "sm/mcpcnfs.h"
#include "sm/mta.h"
#include "sm/sm-conf-time.h"
#include "sm/sm-conf-byte.h"

/*
**  Note: the defaults in here are ignored as long as SM_CONF_FLAG_KEEP_DEFAULT
**  is set, which is necessary to avoid zero'ing out the structure.
*/

#if SM_QMGRCNFDEF
#define EXTERN
#else /* SM_QMGRCNFDEF */
#define EXTERN extern
#endif /* SM_QMGRCNFDEF */

#define QMGR_CNF_AQ_SIZE	"AQ_max_entries"
#define QMGR_CNF_OCC_SIZE	"OCC_max_entries"
#define QMGR_CNF_IBDB_SIZE	"size"
#define QMGR_CNF_IQDB_CACHE_SIZE	"max_cache_entries"
#define QMGR_CNF_IQDB_HASH_TABLE_SIZE	"hash_table_entries"
#define QMGR_CNF_MIN_DISK_SPACE	"min_disk_space"
#define QMGR_CNF_OK_DISK_SPACE	"ok_disk_space"
#define QMGR_CNF_MAX_OPEN_TAS	"max_open_TAs"

#define QMGR_CNF_SC_INITIAL_CONNS	"initial_connections"
#define QMGR_CNF_SC_MAX_CONNS		"max_connections"
#define QMGR_CNF_SS_MAX_OPEN_CONNS	"max_connections"
#define QMGR_CNF_SS_MAX_CONN_RATE	"max_connection_rate"
#define QMGR_CNF_SS_CONNCTL_SIZE	"connection_control_hash_table_size"

#define QMGR_CNF_SC_SMTP_RCPTS_TA	"smtp_max_rcpts_per_transaction"
#define QMGR_CNF_SC_LMTP_RCPTS_TA	"lmtp_max_rcpts_per_transaction"

#define QMGR_CNF_MAX_ERRORS_PER_DSN	"max_errors_per_DSN"
#define QMGR_CNF_FLAGS	"flags"
#define QMGR_CNF_IBDB_MAX_COMMIT_DELAY	"max_commit_delay"
#define QMGR_CNF_MIN_DELAY_RETRIES	"retry_min_delay"
#define QMGR_CNF_MAX_DELAY_RETRIES	"retry_max_delay"
#define QMGR_CNF_TMOUT_QUEUERETURN	"queue_return_timeout"
#define QMGR_CNF_TMOUT_QUEUEDELAY	"queue_delay_timeout"
#define QMGR_CNF_TMOUT_AR	"SMAR_timeout"
#define QMGR_CNF_TMOUT_DELIVERY	"delivery_timeout"
#define QMGR_CNF_TMOUT_SCHED	"scheduler_timeout"
#define QMGR_CNF_MAX_DSN_DELAY	"merge_delay_max"
#define QMGR_CNF_WAIT_FOR_SERVER	"wait_for_server"
#define QMGR_CNF_WAIT_FOR_CLIENT	"wait_for_client"
#define QMGR_CNF_LOG_LEVEL	"log_level"
#define QMGR_CNF_DEBUG_LEVEL	"debug_level"
#define QMGR_CNF_TESTS	"tests"
#define QMGR_CNF_MIN_THR	"min_threads"
#define QMGR_CNF_MAX_THR	"max_threads"
#define QMGR_CNF_MAX_FD		"max_fds"

#define QMEDB_CNF_BASEDIR	"base_directory"
#define QMEDB_CNF_LOGDIR	"log_directory"
#define QMEDB_CNF_PAGESIZE	"page_size"
#define QMEDB_CNF_CACHESIZE	"cache_size"
#define QMEDB_CNF_CHKP_KB	"KBytes_written_for_checkpointing"
#define QMEDB_CNF_CHKP_DELAY	"delay_between_2_checkpoints"
#define QMEDB_CNF_FATAL_RCVR	"fatal_recovery"
#define QMEDB_CNF_RM_LOGFILES	"remove_unused_logfiles"

EXTERN
sm_conf_definition_T const
qmgr_flag_names[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "Reuse_connection",	sm_conf_type_choice_value,
	QCNF_FL_SE_REUSE,
	0, NULL, 0, NULL, NULL, NULL,
	"reuse existing connection if possible" },
{ SM_CONF_DEF_MAGIC, "Header_only_in_DSN",	sm_conf_type_choice_value,
	QCNF_FL_B_HDR,
	0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "DSN_in_MIME_Format",	sm_conf_type_choice_value,
	QCNF_FL_B_DSN_MIME,
	0, NULL, 0, NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;

EXTERN
sm_conf_definition_T const
qmgr_dsn_flag_names[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "header_only",	sm_conf_type_choice_value,
	QCNF_FL_B_HDR,
	0, NULL, 0, NULL, NULL, NULL,
	"send only headers in a DSN" },
{ SM_CONF_DEF_MAGIC, "MIME_format",	sm_conf_type_choice_value,
	QCNF_FL_B_DSN_MIME,
	0, NULL, 0, NULL, NULL, NULL,
	"send DSN in MIME format" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;


EXTERN
sm_conf_definition_T
qmgr_dsn_defs[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, QMGR_CNF_MAX_ERRORS_PER_DSN,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_dsn_rcpts_max),	sizeof(uint),
	SM_XSTR(AQR_DSN_RCPTS_MAX),	0,	NULL,	NULL,	NULL,
	"maximum number of error messages (failed recipients) in a bounce (DSN)"	},

{ SM_CONF_DEF_MAGIC, QMGR_CNF_MAX_DSN_DELAY,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_t_sched_dsn),	sizeof(uint),
	SM_XSTR(QM_TMO_SCHED_DSN),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum time to wait for merging multiple DSNs into one"	},

{ SM_CONF_DEF_MAGIC, QMGR_CNF_FLAGS,			sm_conf_type_choice,
	offsetof(qmgr_cnf_T, q_cnf_flags),		sizeof(uint),
	NULL,	SM_CONF_FLAG_MULTIPLE|SM_CONF_FLAG_OR,	qmgr_dsn_flag_names,
	NULL,	NULL, "Flags for DSN handling" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;


EXTERN
sm_conf_definition_T const
qmgr_edb_flag_names[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, QMEDB_CNF_FATAL_RCVR,	sm_conf_type_choice_value,
	EDB_OPEN_RECOVER_FATAL,
	0, NULL, 0, NULL, NULL, NULL, "perform fatal recovery" },

{ SM_CONF_DEF_MAGIC, QMEDB_CNF_RM_LOGFILES,	sm_conf_type_choice_value,
	EDB_LOG_AUTOREMOVE,
	0, NULL, 0, NULL, NULL, NULL,
	"automatically remove unused logfiles" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;


EXTERN
sm_conf_definition_T
qmgr_edb_defs[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, QMEDB_CNF_BASEDIR,	sm_conf_type_string,
	offsetof(qmgr_cnf_T, q_cnf_edb_cnf.edbcnf_basedir),	0,
	NULL,	0,	NULL,	NULL,	NULL,
	"Home directory for DEFEDB"	},

{ SM_CONF_DEF_MAGIC, QMEDB_CNF_LOGDIR,	sm_conf_type_string,
	offsetof(qmgr_cnf_T, q_cnf_edb_cnf.edbcnf_logdir),	0,
	NULL,	0,	NULL,	NULL,	NULL,
	"Log directory for DEFEDB"	},

{ SM_CONF_DEF_MAGIC, QMEDB_CNF_PAGESIZE,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_edb_cnf.edbcnf_pagesize),
	sizeof(uint),
	NULL,	0,	sm_conf_byte_suffixes,	NULL,	NULL,
	"DB page size"	},

{ SM_CONF_DEF_MAGIC, QMEDB_CNF_CACHESIZE,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_edb_cnf.edbcnf_cachesize),
	sizeof(uint),
	SM_XSTR(EDB_CACHE_DFLT), 0,	sm_conf_byte_suffixes,	NULL,	NULL,
	"DB cache size"	},

{ SM_CONF_DEF_MAGIC, QMEDB_CNF_CHKP_KB,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_edb_cnf.edbcnf_chkpt_kb),
	sizeof(uint32_t),
	NULL,	0,	sm_conf_Kbyte_suffixes,	NULL,	NULL,
	"If non-zero, a checkpoint will be done if more than the amount of"
	" KBytes of log data have been written since the last checkpoint" },

{ SM_CONF_DEF_MAGIC, QMEDB_CNF_CHKP_DELAY,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_edb_cnf.edbcnf_chkpt_delay),
	sizeof(uint32_t),
	SM_XSTR(EDB_SWEEP_DELAY), 0,	sm_conf_time_suffixes,	NULL,	NULL,
	"Minimum delay between two checkpoints" },

{ SM_CONF_DEF_MAGIC, QMGR_CNF_FLAGS,			sm_conf_type_choice,
	offsetof(qmgr_cnf_T, q_cnf_edb_cnf.edbcnf_oflags),	sizeof(uint),
	NULL,	SM_CONF_FLAG_MULTIPLE|SM_CONF_FLAG_OR,	qmgr_edb_flag_names,
	NULL,	NULL,
	"flags for DEFEDB"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;

EXTERN
sm_conf_definition_T
qmgr_ibdb_defs[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, QMGR_CNF_IBDB_SIZE,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_ibdb_size),	sizeof(uint),
	SM_XSTR(IBDB_SIZE),	0,	sm_conf_byte_suffixes,
	NULL,	NULL,
	"maximum size of each IBDB file"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_MAX_OPEN_TAS,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_optas),		sizeof(uint),
	SM_XSTR(IBDB_OPEN_TAS),	0,	NULL,	NULL,	NULL,
	"maximum number of open transactions in IBDB before a commit is performed"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_IBDB_MAX_COMMIT_DELAY,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_ibdb_delay),	sizeof(uint),
	SM_XSTR(IBDB_DELAY),	0,	NULL,	NULL,	NULL,
	"maximum time between commits to IBDB (micro seconds)"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;


EXTERN
sm_conf_definition_T
qmgr_smtpc_defs[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, QMGR_CNF_SC_INITIAL_CONNS,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_init_conc_conn),	sizeof(uint),
	SM_XSTR(DA_INIT_CONC_CONN),	0,	NULL,	NULL,	NULL,
	"initial number of outgoing connections to a single host"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_SC_MAX_CONNS,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_max_conc_conn),	sizeof(uint),
	SM_XSTR(DA_MAX_CONC_CONN),	0,	NULL,	NULL,	NULL,
	"maximum number of outgoing connections to a single host"	},

{ SM_CONF_DEF_MAGIC, QMGR_CNF_SC_SMTP_RCPTS_TA,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_smtp_rcpts_ta),	sizeof(uint),
	SM_XSTR(DA_MAX_RCPTS_TA),	0,	NULL,	NULL,	NULL,
	"maximum number of recipients per transaction (smtp)"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_SC_LMTP_RCPTS_TA,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_lmtp_rcpts_ta),	sizeof(uint),
	SM_XSTR(DA_MAX_RCPTS_TA),	0,	NULL,	NULL,	NULL,
	"maximum number of recipients per transaction (lmtp)"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;

EXTERN
sm_conf_definition_T
qmgr_smtps_defs[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, QMGR_CNF_SS_MAX_OPEN_CONNS,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_max_open_se),	sizeof(uint),
	SM_XSTR(SS_MAX_OPEN_SE),	0,	NULL,	NULL,	NULL,
	"maximum number of open incoming connection from a single host"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_SS_MAX_CONN_RATE,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_max_conn_rate),	sizeof(uint),
	SM_XSTR(SS_MAX_CONN_RATE),	0,	NULL,	NULL,	NULL,
	"maximum incoming connection rate from a single host"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_SS_CONNCTL_SIZE,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_ss_cc_size),	sizeof(uint),
	SM_XSTR(SS_CONNCTL_SIZE),	0,	NULL,	NULL,	NULL,
	"size of connection control hash table [experts only]"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;


EXTERN
sm_conf_definition_T
qmgr_iqdb_defs[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, QMGR_CNF_IQDB_CACHE_SIZE,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_iqdb_csize), sizeof(uint),
	SM_XSTR(IQDB_CSIZE),	0,	NULL,	NULL,	NULL,
	"maximum number of entries in IQDB cache"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_IQDB_HASH_TABLE_SIZE,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_iqdb_htsize),	sizeof(uint),
	SM_XSTR(IQDB_HTSIZE),	0,	NULL,	NULL,	NULL,
	"size of hash table for IQDB"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;

EXTERN
sm_conf_definition_T
qmgr_defs[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, QMGR_CNF_AQ_SIZE,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_aq_size),	sizeof(uint),
	SM_XSTR(AQ_SIZE),	0,	NULL,	NULL,	NULL,
	"maximum number of entries in AQ (active queue)"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_OCC_SIZE,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_occ_size),	sizeof(uint),
	SM_XSTR(OCC_CSIZE),	0,	NULL,	NULL,	NULL,
	"maximum number of entries in OCC (outgoing connection cache)"	},

{ SM_CONF_DEF_MAGIC, "IBDB", sm_conf_type_section,
	0, sizeof(qmgr_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT,
	qmgr_ibdb_defs, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "IQDB", sm_conf_type_section,
	0, sizeof(qmgr_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT,
	qmgr_iqdb_defs, NULL, NULL, NULL  },

{ SM_CONF_DEF_MAGIC, QMGR_CNF_MIN_DISK_SPACE,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_min_df),		sizeof(uint),
	SM_XSTR(DISK_MIN_FREE),	0,	sm_conf_Kbyte_suffixes,
	NULL,	NULL,
	"minimum amount of free disk space (KB)"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_OK_DISK_SPACE,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_ok_df),		sizeof(uint),
	SM_XSTR(DISK_OK_FREE),	0,	sm_conf_Kbyte_suffixes,
	NULL,	NULL,
	"amount of free disk space at which normal operation continues (KB)"	},

{ SM_CONF_DEF_MAGIC, "smtpc", sm_conf_type_section,
	0, sizeof(qmgr_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT,
	qmgr_smtpc_defs, NULL, NULL, NULL  },

{ SM_CONF_DEF_MAGIC, "smtps", sm_conf_type_section,
	0, sizeof(qmgr_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT,
	qmgr_smtps_defs, NULL, NULL, NULL  },

{ SM_CONF_DEF_MAGIC, QMGR_CNF_FLAGS,			sm_conf_type_choice,
	offsetof(qmgr_cnf_T, q_cnf_flags),		sizeof(uint),
	NULL,	SM_CONF_FLAG_MULTIPLE|SM_CONF_FLAG_OR,	qmgr_flag_names,
	NULL,	NULL,
	""	},

{ SM_CONF_DEF_MAGIC, QMGR_CNF_MIN_DELAY_RETRIES,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_min_delay),	sizeof(uint),
	SM_XSTR(MIN_DELAY_NXT_TRY),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"minimum time for retrying a delivery"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_MAX_DELAY_RETRIES,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_max_delay),	sizeof(uint),
	SM_XSTR(MAX_DELAY_NXT_TRY),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum time for retrying a delivery"	},

{ SM_CONF_DEF_MAGIC, QMGR_CNF_TMOUT_QUEUERETURN,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_tmo_return),	sizeof(uint),
	SM_XSTR(QM_TMO_RETURN),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum time in queue"	},

{ SM_CONF_DEF_MAGIC, QMGR_CNF_TMOUT_QUEUEDELAY,	sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_tmo_delay),	sizeof(uint),
	SM_XSTR(QM_TMO_DELAY),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"send delay warning after this time in queue"	},

{ SM_CONF_DEF_MAGIC, QMGR_CNF_TMOUT_AR,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_tmo_ar),	sizeof(uint),
	SM_XSTR(AQR_AR_TMOUT),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"timeout in address resolver"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_TMOUT_DELIVERY,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_tmo_da),	sizeof(uint),
	SM_XSTR(AQR_DA_TMOUT),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"timeout for a single delivery attempt"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_TMOUT_SCHED,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_tmo_sched),	sizeof(uint),
	SM_XSTR(AQR_SCHED_TMOUT),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum time waiting to be scheduled"	},

{ SM_CONF_DEF_MAGIC, QMGR_CNF_WAIT_FOR_SERVER,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_wait4srv),	sizeof(uint),
	"1",	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum amount of time to wait for a server to become available"	},
{ SM_CONF_DEF_MAGIC, QMGR_CNF_WAIT_FOR_CLIENT,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_wait4clt),	sizeof(uint),
	"1",	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum amount of time to wait for a client to become available"	},

{ SM_CONF_DEF_MAGIC, QMGR_CNF_LOG_LEVEL,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_loglevel),	sizeof(uint),
	SM_XSTR(SM_LOG_LEVEL),	0,	NULL,	NULL,	NULL,
	""	},

{ SM_CONF_DEF_MAGIC, "log", sm_conf_type_section,
	offsetof(qmgr_cnf_T, q_cnf_log),	0,
	NULL, SM_CONF_FLAG_KEEP_DEFAULT, sm_log_spec_defs,
	NULL,	NULL,
	SM_CNF_LOG	},

#if QMGR_DEBUG
{ SM_CONF_DEF_MAGIC, QMGR_CNF_DEBUG_LEVEL,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_debug),	sizeof(uint),
	"0", 0, NULL, NULL, NULL, NULL	},
#endif /* QMGR_DEBUG */

#if QMGR_TEST
{ SM_CONF_DEF_MAGIC, QMGR_CNF_TESTS,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_tests),	sizeof(uint),
	"0", 0, NULL, NULL, NULL, NULL  },
#endif /* QMGR_TEST */

{ SM_CONF_DEF_MAGIC, "DSN_handling",	sm_conf_type_section,
	0, sizeof(qmgr_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT, qmgr_dsn_defs,
	NULL, NULL, NULL  },

{ SM_CONF_DEF_MAGIC, "DEFEDB", sm_conf_type_section,
	0, sizeof(edb_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT, qmgr_edb_defs,
	NULL, NULL, NULL  },

{ SM_CONF_DEF_MAGIC, "control_socket",	sm_conf_type_string,
	offsetof(qmgr_cnf_T, q_cnf_ctlsock),	0,
	NULL, 0, NULL, NULL, NULL, "name of control socket"  },

{ SM_CONF_DEF_MAGIC, "conf",	sm_conf_type_string,
	offsetof(qmgr_cnf_T, q_cnf_confmap_fn),	0,
	"qmgr_conf.db", 0, NULL, NULL, NULL,
	"name of configuration map (including extension)"	},

{ SM_CONF_DEF_MAGIC, EVTHR_CNF_MIN_THR,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_min_thr),	sizeof(uint),
	SM_XSTR(SM_QMGR_MIN_THR),	0,	NULL,	NULL,	NULL,
	EVTHR_COMM_MIN_THR	},
{ SM_CONF_DEF_MAGIC, EVTHR_CNF_MAX_THR,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_max_thr),	sizeof(uint),
	SM_XSTR(SM_QMGR_MAX_THR),	0,	NULL,	NULL,	NULL,
	EVTHR_COMM_MAX_THR	},
{ SM_CONF_DEF_MAGIC, EVTHR_CNF_MAX_FD,		sm_conf_type_u32,
	offsetof(qmgr_cnf_T, q_cnf_max_fd),	sizeof(uint),
	SM_XSTR(SM_QMGR_MAX_FD),	0,	NULL,	NULL,	NULL,
	EVTHR_COMM_MAX_FD	},

	MCP_DEFS(qmgr_cnf_T, q_cnf)

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;

EXTERN
sm_conf_definition_T
qmgr_global_defs[]
#if SM_QMGRCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "SMTPC_socket",	sm_conf_type_string,
	offsetof(qmgr_cnf_T, q_cnf_smtpcsock),	0,	smsmtpcsock,
	0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "SMTPS_socket",	sm_conf_type_string,
	offsetof(qmgr_cnf_T, q_cnf_smtpssock),	0,	smsmtpssock,
	0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "SMAR_socket",	sm_conf_type_string,
	offsetof(qmgr_cnf_T, q_cnf_smarsock),	0,	smarsock,
	0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "CDB_base_directory",	sm_conf_type_string,
	offsetof(qmgr_cnf_T, q_cnf_cdb_base),	0,	"",
	0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "hostname",		sm_conf_type_string,
	offsetof(qmgr_cnf_T, q_cnf_hostname),	0,	NULL,
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "qmgr", sm_conf_type_section,
	0, sizeof(qmgr_cnf_T), NULL, SM_CONF_FLAG_KEEP_DEFAULT, qmgr_defs,
	NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_QMGRCNFDEF */
;

#undef EXTERN

#endif /* SM_QMGRCNFDEF_H */
