/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: magic.h,v 1.53 2005/06/16 00:09:34 ca Exp $
 */

/* It's a kind of Magic (Queen: Highlander) */

#ifndef SM_MAGIC_H
#define SM_MAGIC_H 1

#include "sm/generic.h"

typedef int32_t	sm_magic_T;

/* no magic at all */
#define SM_MAGIC_NULL	((sm_magic_T) 0)

/*
**  Notes:
**  It is not such a good idea to have all the magic in one place,
**  it should be "distributed", i.e., local to the various libraries/modules.
**  The following naming pattern must be used: SM_[A-Z_]*_MAGIC
**  to simplify finding magic values:
**	grep '# *define  *\<SM_[A-Z_]*_MAGIC\>' filenames
**
**  Maybe add a "version" number to this magic?
**  Then we could "detect" if libraries from different version are used.
*/

/* Notice: may have to cast each entry to uint8_t */
#define SM_MAGIC(a, b, c, d) ((sm_magic_T) ((a) << 24 | (b) << 16 | (c) << 8 | d))

/*
**  To print this in a debugger, use hex format or x/4c sm_magic
*/

#define SM_RPOOL_MAGIC SM_MAGIC('R', 'P', 'O', 'L')
#define SM_STRBUF_MAGIC	0x1234AAAA
#define SM_STR_MAGIC	SM_MAGIC('S', 'T', 'R', 'I')
#define SM_RCB_MAGIC	SM_STR_MAGIC
#define SM_CSTR_MAGIC	SM_MAGIC('C', 'S', 'T', 'R')
/* #define SM_RCB_MAGIC	SM_MAGIC('R', 'C', 'B', 'u') */
#define SM_RSC_MAGIC	SM_MAGIC('R', 'S', 'C', 'T')
#define SM_DEBUG_MAGIC	0x0102beef
#define SM_FILE_MAGIC	SM_MAGIC('F', 'I', 'L', 'E')
#define SM_STREAM_MAGIC	SM_MAGIC('S', 'r', 'a', 'm')

#define SM_MCTX_MAGIC	SM_MAGIC('M', 'C', 'T', 'X')

/* QMGR */
#define SM_QMGR_CTX_MAGIC	SM_MAGIC('Q', 'M', 'G', 'R')
#define SM_QSS_CTX_MAGIC	SM_MAGIC('Q', 'S', 'S', 'c')
#define SM_QSS_SE_MAGIC		SM_MAGIC('Q', 'S', 's', 'S')
#define SM_QSS_TA_MAGIC		SM_MAGIC('Q', 'S', 's', 'T')
#define SM_QSC_CTX_MAGIC	SM_MAGIC('Q', 'S', 'C', 'c')
#define SM_QAR_CTX_MAGIC	SM_MAGIC('Q', 'A', 'R', 'r')
#define SM_QCLEANUP_CTX_MAGIC	SM_MAGIC('Q', 'C', 'L', 'U')
#define SM_GLI_MAGIC		SM_MAGIC('Q', 'G', 'L', 'I')

/* libqmgr */
#define SM_TAC_CTX_MAGIC	SM_MAGIC('T', 'A', 'C', 'X')

/* AQ */
#define SM_AQ_MAGIC		SM_MAGIC('A', 'c', 'D', 'B')
#define SM_AQ_TA_MAGIC		SM_MAGIC('A', 'Q', 'T', 'A')
#define SM_AQ_DTA_MAGIC		SM_MAGIC('A', 'D', 'T', 'A')
#define SM_AQ_RCPT_MAGIC	SM_MAGIC('A', 'Q', 'R', 'c')
#define SM_AQOOCCE_MAGIC	SM_MAGIC('A', 'Q', 'O', 'C')

/* DA DB */
#define SM_DADB_MAGIC		SM_MAGIC('D', 'A', 'D', 'B')
#define SM_DADBE_MAGIC		SM_MAGIC('D', 'A', 'D', 'e')

/* EDBC */
#define SM_EDBC_MAGIC		SM_MAGIC('E', 'D', 'B', 'C')

/* EDB context */
#define SM_EDB_CTX_MAGIC	SM_MAGIC('E', 'D', 'C', 'X')

/* EDB conf */
#define SM_EDB_CNF_MAGIC	SM_MAGIC('E', 'D', 'C', 'N')

/* CDB */
#define SM_CDB_MAGIC		SM_MAGIC('C', 'D', 'B', 'x')

/* Event Threads system */
#define SM_EVTHR_CTX_MAGIC	SM_MAGIC('E', 'T', 'h', 'C')
#define SM_EVTHR_TASK_MAGIC	SM_MAGIC('E', 'T', 'h', 'T')

/* SMAR */
#define SM_SMAR_CTX_MAGIC	SM_MAGIC('S', 'M', 'A', 'R')
#define SM_SMAC_CTX_MAGIC	SM_MAGIC('S', 'M', 'A', 'C')
#define SM_SMAR_RCPT_MAGIC	SM_MAGIC('A', 'R', 'R', 'C')
#define SM_SMAR_RCPTS_MAGIC	SM_MAGIC('A', 'R', 'R', 'S')
#define SM_SMAR_ADDR_MAGIC	SM_MAGIC('A', 'D', 'D', 'R')

/* SMTPS */
#define SM_SS_CTX_MAGIC		SM_MAGIC('S', 'S', 'C', 'T')
#define SM_SS_SESS_MAGIC	SM_MAGIC('S', 'S', 'S', 'E')
#define SM_SS_TA_MAGIC		SM_MAGIC('S', 'S', 'T', 'A')

/* SMTPS */
#define SM_SC_CTX_MAGIC		SM_MAGIC('S', 'C', 'C', 'T')
#define SM_SC_SESS_MAGIC	SM_MAGIC('S', 'C', 'S', 'E')
#define SM_SC_TA_MAGIC		SM_MAGIC('S', 'C', 'T', 'A')

#define SM_OCCX_MAGIC		SM_MAGIC('O', 'C', 'C', 'X')
#define SM_OCCE_MAGIC		SM_MAGIC('O', 'C', 'C', 'E')

#define SM_SSOCC_MAGIC		SM_MAGIC('S', 'O', 'C', 'X')
#define SM_SSOCCE_MAGIC		SM_MAGIC('S', 'O', 'C', 'E')

#define SM_AQRDQ_MAGIC		SM_MAGIC('A', 'R', 'D', 'Q')

/* connection control context */
#define SM_CONNCTL_MAGIC	SM_MAGIC('C', 'O', 'C', 'T')

/* maps context */
#define SM_MAPS_MAGIC	SM_MAGIC('M', 'A', 'P', 'S')
#define SM_MAPC_MAGIC	SM_MAGIC('M', 'A', 'P', 'C')
#define SM_MAP_MAGIC	SM_MAGIC('M', 'A', 'P', '_')

#endif /* ! SM_MAGIC_H */
