/*
 * Copyright (c) 2000-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: limits.h,v 1.9 2005/06/03 01:15:18 ca Exp $
 */

/*
**  <sm/limits.h>
**  This header file is a portability wrapper for <limits.h>.
**  It includes <limits.h>, then it ensures that the following macros
**  from the C 1999 standard for <limits.h> are defined:
**	LLONG_MIN, LLONG_MAX
**	ULLONG_MAX
*/

#ifndef SM_LIMITS_H
#define SM_LIMITS_H 1

#include "sm/generic.h"
#if HAVE_LIMITS_H
#include <limits.h>
#endif
#include "sm/types.h"
#if HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

/*
**  The following assumes two's complement binary arithmetic.
*/

#ifndef LLONG_MIN
# define LLONG_MIN	((longlong_T)(~(ULLONG_MAX >> 1)))
#endif
#ifndef LLONG_MAX
# define LLONG_MAX	((longlong_T)(ULLONG_MAX >> 1))
#endif
#ifndef ULLONG_MAX
# define ULLONG_MAX	((ulonglong_T)(-1))
#endif

#define ONEKB	1024

/*
**  PATH_MAX is defined by the POSIX standard.  All modern systems
**  provide it.  Older systems define MAXPATHLEN in <sys/param.h> instead.
*/

#ifndef PATH_MAX
# ifdef MAXPATHLEN
#  define PATH_MAX	MAXPATHLEN
# else
#  define PATH_MAX	2048
# endif
#endif /* ! PATH_MAX */

#ifndef SIZE_T_MAX
# if SIZEOF_SIZE_T == 0
#  error oops sizeof(size_t) is unknown
# elif SIZEOF_SIZE_T == 2
#  if HAVE_UNSIGNED_SIZE_T
#   define SIZE_T_MAX	32767
#  else
#   define SIZE_T_MAX	65535
#  endif
# elif SIZEOF_SIZE_T == 4
#  if HAVE_UNSIGNED_SIZE_T
#   define SIZE_T_MAX	0xffffffff
#  else
#   define SIZE_T_MAX	2147483647
#  endif
# elif SIZEOF_SIZE_T == 8
#  if HAVE_UNSIGNED_SIZE_T
#   define SIZE_T_MAX	ULONG_MAX
#  else
#   define SIZE_T_MAX	LONG_MAX
#  endif
# else /* SIZEOF_SIZE_T == 0 */
#  error oops sizeof(size_t) == SIZEOF_SIZE_T not valid
# endif /* SIZEOF_SIZE_T == 0 */
#endif /* ! SIZE_T_MAX */

#ifndef UINT32_MAX
# define UINT32_MAX	0xffffffffu
#endif

#ifndef INT32_MAX
# define INT32_MAX	0x7fffffff
#endif

#ifndef UINT64_MAX
# define UINT64_MAX	0xffffffffffffffffULL
#endif

#endif /* ! SM_LIMITS_H */
