/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: iqdb.h,v 1.17 2005/09/29 17:17:49 ca Exp $
 */

#ifndef SM_IQDB_H
#define SM_IQDB_H 1

#include "sm/generic.h"
#include "sm/error.h"
#include "sm/rsct.h"

/* abstraction layer for iqdb (Incoming Queue envelope DB, memory only) */

#if 0

from db.func.tex:

iqdb_open(IN name, IN mode, IN size, OUT status, OUT iqdb-handle):
open an incoming envelope database.

iqdb_close(IN iqdb-handle, OUT status):
close an incoming envelope database.

iqdb_session_new(IN iqdb-handle, IN session-info, OUT status, OUT session-id):
create a new session (client connects succesfully).

iqdb_trans_new(IN iqdb-handle, IN sender-env-info, OUT status, OUT trans-id):
create a new envelope (done on MAIL command).

iqdb_rcpt_add(IN iqdb-handle, IN trans-id, IN rcpt-env-info, OUT status):
add a new recipient (RCPT command).

iqdb_rcpt_rm(IN iqdb-handle, IN trans-id, IN rcpt-id, IN rpct-status, OUT status):
remove a recipient (mail has been taken care of).

iqdb_trans_rm(IN iqdb-handle, IN trans-id, OUT status):
remove an envelope from the EDB (after all recipients have been taken care of).
Should this be done implicitly when all recipients have been removed?

iqdb_commit(IN iqdb-handle, IN trans-id, OUT status):
commit envelope information to stable storage.

iqdb_session_rm(IN iqdb-handle, IN session-id, OUT status):
remove a session from the EDB.

iqdb_trans_discard(IN iqdb-handle, IN trans-id, OUT status):
discard envelope (connection has been aborted somehow)

iqdb_items_cache(IN iqdb-handle, OUT items, OUT status):
return the number of items in the memory cache.

#endif /* 0 */

/* types of entries in RSC */
#define IQDB_T_SESS	0
#define IQDB_T_TA	1
#define IQDB_T_RCPT	2

typedef struct rsct_S iqdb_T, *iqdb_P;

typedef void	*(*iqdb_create_F) (const char *, uint, void *, void *, uint);
typedef sm_ret_T (*iqdb_delete_F) (void *, void *, uint);

/* function type to apply to all entries in cache */
typedef void (iqdb_walk_F)(const char *, const void *, const void *, uint);

#define iqdb_open(limit, htsize, create, delete, context)	\
		rsct_new(limit, htsize, create, delete, context)

#define iqdb_close(iqdb) rsct_free(iqdb)
#define iqdb_walk(iqdb, action, ctx, lt) rsct_walk(iqdb, action, ctx, lt)

#define iqdb_session_new(iqdb, key, len, value, pvalue, lt)	\
		rsct_add(iqdb, false, IQDB_T_SESS, key, len, value, pvalue, lt)

#define iqdb_trans_new(iqdb, key, len, value, pvalue, lt)	\
		rsct_add(iqdb, false, IQDB_T_TA, key, len, value, pvalue, lt)
#define iqdb_rcpt_add(iqdb, key, len, value, pvalue, lt)	\
		rsct_add(iqdb, false, IQDB_T_RCPT, key, len, value, pvalue, lt)

/* specific session/transaction/... functions? */
#define iqdb_lookup(cache, key, len, lt) rsct_lookup(cache, key, len, lt)

#define iqdb_session_rm(iqdb, key, len, lt) rsct_rm(iqdb, key, len, lt)
#define iqdb_trans_rm(iqdb, key, len, lt) rsct_rm(iqdb, key, len, lt)
#define iqdb_rcpt_rm(iqdb, key, len, lt) rsct_rm(iqdb, key, len, lt)

#define iqdb_usage(iqdb) rsct_usage(iqdb)
#define iqdb_entries(iqdb, pmax_used) rsct_entries(iqdb, pmax_used)
#define iqdb_stats(iqdb, out, len) rsct_stats(iqdb, out, len)

#endif /* SM_IQDB_H */
