/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: edbcnf.h,v 1.6 2005/07/21 20:35:04 ca Exp $
 */

#ifndef SM_EDBCNF_H
#define SM_EDBCNF_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/magic.h"

typedef struct edb_cnf_S	edb_cnf_T, *edb_cnf_P;

struct edb_cnf_S
{
	sm_magic_T	 sm_magic;
	char		*edbcnf_basedir;
	char		*edbcnf_logdir;
	char		*edbcnf_err_prefix;
	uint		 edbcnf_size;
	uint		 edbcnf_oflags;	/* flags for open call */
	uint		 edbcnf_pagesize;
	uint		 edbcnf_cachesize;

	/* checkpoint data: minimum KBytes, delay (s) */
	uint32_t	 edbcnf_chkpt_kb;
	uint32_t	 edbcnf_chkpt_delay;
};

/* XXX HACK name for DEFEDB */
#define EDB_NAME	"defedb.db"
#define EDB_HOME	"defedb"
#define EDB_NAME_RD	"defedb/defedb.db"

#define EDB_CACHE_DFLT	4 *1024*1024	/* for configuration definition */
#define EDB_CACHE	(EDB_CACHE_DFLT)

#endif /* SM_EDBCNF_H */
