/*
 * Copyright (c) 2000-2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: debug.h,v 1.8 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_DEBUG_H
#define SM_DEBUG_H 1

#include "sm/generic.h"
#include "sm/magic.h"

#define tTd(x,y)	false

/*
XXX CHANGE THIS...
*/

#if 0
/*
**  abstractions for printing trace messages
*/

sm_file_T	*sm_debug_file(void);

void	sm_debug_setfile(sm_file_T *);

void PRINTFLIKE(1, 2)	sm_dprintf(char *_fmt, ...);

void	sm_dflush(void);

/*
**  abstractions for setting and testing debug activation levels
*/

void	sm_debug_addsettings_x(const char *);

void	sm_debug_addsetting_x(const char *, int);

# define SM_DEBUG_UNKNOWN	((SM_ATOMIC_UINT_T)(-1))

typedef struct sm_debug SM_DEBUG_T;
struct sm_debug
{
	sm_magic_T	sm_magic;	/* SM_DEBUG_MAGIC */

	/*
	**  debug_level is the activation level of this debug
	**  object.  Level 0 means no debug activity.
	**  It is initialized to SM_DEBUG_UNKNOWN, which indicates
	**  that the true value is unknown.  If debug_level ==
	**  SM_DEBUG_UNKNOWN, then the access functions will look up
	**  its true value in the internal table of debug settings.
	*/

	SM_ATOMIC_UINT_T debug_level;

	/*
	**  debug_name is the name used to reference this SM_DEBUG
	**  structure via the sendmail -d option.
	*/

	char *debug_name;

	/*
	**  debug_desc is a literal character string of the form
	**  "@(#)$Debug: <name> - <short description> $"
	*/

	char *debug_desc;

	/*
	**  We keep a linked list of initialized SM_DEBUG structures
	**  so that when sm_debug_addsetting is called, we can reset
	**  them all back to the uninitialized state.
	*/

	SM_DEBUG_T *debug_next;
};

# ifndef SM_DEBUG_CHECK
#  define SM_DEBUG_CHECK 1
# endif /* ! SM_DEBUG_CHECK */

# if SM_DEBUG_CHECK
/*
**  This macro is cleverly designed so that if the debug object is below
**  the specified level, then the only overhead is a single comparison
**  (except for the first time this macro is invoked).
*/

#  define sm_debug_active(debug, level) \
	    ((debug)->debug_level >= (level) && \
	     ((debug)->debug_level != SM_DEBUG_UNKNOWN || \
	      sm_debug_loadactive(debug, level)))

#  define sm_debug_level(debug) \
	    ((debug)->debug_level == SM_DEBUG_UNKNOWN \
	     ? sm_debug_loadlevel(debug) : (debug)->debug_level)

#  define sm_debug_unknown(debug) ((debug)->debug_level == SM_DEBUG_UNKNOWN)
# else /* SM_DEBUG_CHECK */
#  define sm_debug_active(debug, level)	0
#  define sm_debug_level(debug)		0
#  define sm_debug_unknown(debug)	0
# endif /* SM_DEBUG_CHECK */

bool sm_debug_loadactive(SM_DEBUG_T *, int);

int sm_debug_loadlevel(SM_DEBUG_T *);

# define SM_DEBUG_INITIALIZER(name, desc) { \
		SmDebugMagic, \
		SM_DEBUG_UNKNOWN, \
		name, \
		desc, \
		NULL}

#else /* 0 */

typedef int SM_DEBUG_T;

#endif /* 0 */


#endif /* ! SM_DEBUG_H */
