/*
 * Copyright (c) 1983, 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Copyright (c) 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: conncache.h,v 1.3 2003/05/27 20:26:04 ca Exp $
 */

#ifndef SM_CONNCACHE_H
#define SM_CONNCACHE_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/magic.h"
#include "sm/net.h"

typedef struct cc_ctx_S	cc_ctx_T, *cc_ctx_P;

/* time granularity: 10s (that's one "tick") */
#define CHTGRAN		10
#define CHTSIZE		6

/* Number of connections for a certain "tick" */
struct cc_time_S
{
	ulong	 cct_ticks;
	int	 cct_count;
};
typedef struct cc_time_S	cc_time_T, *cc_time_P;

/*
**  XXX This should be "flexible", i.e., the user application specifies
**  the content. How to do that?
**  See below: create another array that points to some user struct.
*/

struct cc_entry_S
{
	in_addr_T	cce_addr;	/* addr of connection XXX IPv6 */
	time_t		cce_ltime;	/* last touch */
#if SM_CONNCACHE_PERF
	ulong		cce_colls;	/* number of collisions */
#endif

	/* 6 buckets for ticks: 60s */
	cc_time_T	cce_times[CHTSIZE];
};
typedef struct cc_entry_S	cc_entry_T, *cc_entry_P;


sm_ret_T	 sm_conncache_new(unsigned int _size, unsigned int _steps, size_t entry_size, cc_ctx_P *_pcc_ctx);
sm_ret_T	 sm_conncache_free(cc_ctx_P _cc_ctx);
sm_ret_T	 sm_conncache(cc_ctx_P _cc_ctx, in_addr_T _addr, time_t _curt, unsigned int *_pidx, char **_base);
#if SM_CONNCACHE_PERF
sm_ret_T	 sm_conncache_stats(cc_ctx_P _cc_ctx, ulong *_pcolls, ulong *_pmaxcolls, ulong *_punused, ulong *_ptotal);
#endif /* SM_CONNCACHE_PERF */

#if SM_CONNCACHE_CHECK
# define SM_IS_CC_CTX(cc_ctx)	SM_REQUIRE_ISA((cc_ctx), SM_CC_CTX_MAGIC)
#else
# define SM_IS_CC_CTX(cc_ctx)	SM_REQUIRE((cc_ctx) != NULL)
#endif

#endif /* SM_CONNCACHE_H */
