/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: bdb.h,v 1.13 2005/08/29 16:57:44 ca Exp $
 */

#ifndef SM_BDB_H
#define SM_BDB_H 1

#include "sm/io.h"
#include "sm/error.h"

#if HAVE_BERKELEYDB4
# include <db.h>
# if DB_VERSION_MAJOR != 4 || (DB_VERSION_MINOR != 1 && DB_VERSION_MINOR != 2 && DB_VERSION_MINOR != 3)
#  error  wrong DB version, need 4.{1,2,3} got DB_VERSION_MAJOR DB_VERSION_MINOR
# endif
#else
# error  need Berkeley DB 4.{1,2,3}
#endif

#if DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR == 3
# define BDB43STATTXN	NULL,
#else
# define BDB43STATTXN
# define DB_BUFFER_SMALL	ENOMEM
#endif

/* XXX Should this really be here? */
#include "maps.h"

/* setopt values, 0 is reserved! */
#define SMPO_BDB_DB_CACHE_SIZE	SMPO_CACHE_SIZE
#define SMPO_BDB_DB_HASH_NELEM	SMPO_HASH_NELEM


sm_ret_T sm_bdb_class_create(sm_maps_P _maps);
sm_ret_T sm_bdbversionprt(sm_file_T *_fp);
sm_ret_T sm_bdbversionok(void);

#define BDB_ERROR_MIN	(-30999)
#define BDB_ERROR_MAX	(-30800)

#define SM_IS_BDB_ERR(ret) (sm_error_value(ret) >= BDB_ERROR_MIN && sm_error_value(ret) <= BDB_ERROR_MAX)

/*
**  BDB_ERR2RET -- Translates BDB error code to sm error code
**
**	Parameters:
**		err -- The type to translate.
**
**	Returns:
**		usual sm_error code
*/

#define BDB_ERR2RET(err) (((err) == 0) ? SM_SUCCESS :	\
	(((err) == DB_NOTFOUND) ? SM_MAP_NOTFOUND :	\
	(((err) == DB_BUFFER_SMALL) ? SM_MAP_DATA2BIG :	\
	 sm_error_perm(SM_EM_BDB, (err)))))

#endif /* SM_BDB_H */
