/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: aqoocc.h,v 1.13 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_AQOOCC_H
#define SM_AQOOCC_H 1

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/types.h"
#include "sm/time.h"
#include "sm/pthread.h"
#include "sm/net.h"
#include "sm/bhtable.h"
#include "sm/ring.h"
#include "sm/queue.h"
#include "sm/actdb.h"
#include "sm/aqooccstr.h"

#ifndef AQOOCC_CHECK
# define AQOOCC_CHECK	0
#endif

typedef SIMPLEQ_HEAD(, aqoc_entry_S)	aqoc_entry_hd_T, *aqoc_entry_hd_P;

/*
**  Active Queue outgoing Open Connection cache entry.
**  These entries are accessed via a hash table from AQ (aq_ctx->aq_oocc).
**  They just store information about (rcpt) entries in AQ that are
**  being sent to the same destination (only IPv4 address currently).
**  XXX Currently this isn't really used: the system adds and removes
**  entries to it (and keeps the values up to date), but aq_oocc_find()
**  isn't used because scheduler/smtpc do not have a good concept (yet)
**  for session reuse.
**
**  Should there be two aqoce_rcpt links? One for "todo", and one for
**  "busy" (i.e., being delivered)?
**
**  2004-02-13: is this superseded by AQ ready queues?
*/

struct aqoc_entry_S
{
#if AQOOCC_CHECK
	sm_magic_T	 sm_magic;
#endif
/*
	this probably needs individual locking!
	pthread_mutex_t	 aqoce_mutex;
*/
	ipv4_T		 aqoce_srv_ipv4;	/* XXX HACK! */

	uint		 aqoce_flags;
	uint		 aqoce_entries;	/* # of rcpts with same destination */
	aq_rcpt_P	 aqoce_rcpt;	/* pointer to one rcpt entry */

#if 0
	/*
	**  This is used if we keep a "cache" of aqoc_entry_P, compare
	**  occ_entry_P and libdadb/occh.c: occ_entry_new/free
	**  XXX not yet implemented.
	**  This can also link "used" entries together, then the scheduler
	**  can "walk" through the list.
	**  Maybe use a double-linked list go get fancier operations, e.g.,
	**  "rotate" the queue, so the head points to the "next" entry
	**  that should be scheduled (rotation would introduce some kind
	**  of fairness).
	*/

	SIMPLEQ_ENTRY(aqoc_entry_S)	 aqoc_fl;	/* next free entry */
#endif /* 0 */
};

/* AQOOCC entry flags */
#define AQOOCCE_FL_NONE		0x0000	/* guess */
#define AQOOCCE_FL_USED		0x0001	/* in use */

/* TA is waiting, inform scheduler when a transaction is done */
#define AQOOCCE_FL_TA_WAIT		0x0002

#define AQOOCCE_SET_FLAG(aqoc_entry, fl) (aqoc_entry)->aqoce_flags |= (fl)
#define AQOOCCE_CLR_FLAG(aqoc_entry, fl) (aqoc_entry)->aqoce_flags &= ~(fl)
#define AQOOCCE_IS_FLAG(aqoc_entry, fl) (((aqoc_entry)->aqoce_flags & (fl)) != 0)



#if AQOOCC_CHECK
# define SM_IS_AQOOCCE(aqoc_entry)	SM_REQUIRE_ISA((aqoc_entry), SM_AQOOCCE_MAGIC)
#else
# define SM_IS_AQOOCCE(aqoc_entry)	SM_REQUIRE((aqoc_entry) != NULL)
#endif

sm_ret_T aq_oocc_rcpt_add(aq_ctx_P _aq_ctx, aq_rcpt_P _aq_rcpt, bool _lockit);
sm_ret_T aq_oocc_rcpt_rm(aq_ctx_P _aq_ctx, aq_rcpt_P _aq_rcpt, bool _lockit);
sm_ret_T aq_oocc_find(aq_ctx_P _aq_ctx, ipv4_T _ipv4, aqoc_entry_P *_paqoc_entry, thr_lock_T _locktype);

#endif /* SM_AQOOCC_H */
