#ifndef _HTABLE_H_INCLUDED_
#define _HTABLE_H_INCLUDED_

/* $Id: htable.h,v 1.1 2002/02/15 02:14:34 ca Exp $ */

/*++
* NAME
*	htable 3h
* SUMMARY
*	hash table manager
* SYNOPSIS
*	#include <htable.h>
* DESCRIPTION
* .nf
*/

 /* Structure of one hash table entry. */

typedef struct HTABLE_INFO {
    char   *key;			/* lookup key */
    char   *value;			/* associated value */
    struct HTABLE_INFO *next;		/* colliding entry */
    struct HTABLE_INFO *prev;		/* colliding entry */
} HTABLE_INFO;

 /* Structure of one hash table. */

typedef struct HTABLE {
#if 0
    sm_magic_T	sm_magic;
#endif /* 0 */
    sm_rpool_P	rpool;
    int     size;			/* length of entries array */
    int     used;			/* number of entries in table */
    HTABLE_INFO **data;			/* entries array, auto-resized */
} HTABLE;

typedef void (ht_free_F)(char *, void *);
typedef void (ht_walk_F)(HTABLE_INFO *, char *);

extern HTABLE *htable_create(sm_rpool_P, int);
extern HTABLE_INFO *htable_enter(HTABLE *, const char *, char *);
extern HTABLE_INFO *htable_locate(HTABLE *, const char *);
extern char *htable_find(HTABLE *, const char *);
extern void htable_delete(HTABLE *_ht, const char *, ht_free_F *_ff, void *_ctx);
extern void htable_free(HTABLE *_ht, ht_free_F *_ff, void *_ctx);
extern void htable_walk(HTABLE *, ht_walk_F *, char *);
extern HTABLE_INFO **htable_list(HTABLE *);

/* LICENSE
* .ad
* .fi
*	The Secure Mailer license must be distributed with this software.
* AUTHOR(S)
*	Wietse Venema
*	IBM T.J. Watson Research
*	P.O. Box 704
*	Yorktown Heights, NY 10598, USA
* CREATION DATE
*	Fri Feb 14 13:43:19 EST 1997
* LAST MODIFICATION
*	%E% %U%
* VERSION/RELEASE
*	%I%
*--*/

#endif
