#!/bin/sh
# $Id: t-smtpm1.sh,v 1.12 2005/09/01 21:13:16 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test error handling (permanent failure for recipient)
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
I=""
ERRS=0
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

TEST=1

# ----------------------------------------
# delivery attempt to recipient fails, bounce is sent

if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -E 2 -S"m1@b.c" -R"551@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    ERRS=`expr ${ERRS} + 1 `
    ${VERBOSE} && echo "test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  rm -f ${EDBROK}
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
