#!/bin/sh
# $Id: t-smtpa-0.sh,v 1.15 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test alias expansion and error handling.
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
EDBROK="../qmgr/t-smtpa-0-edbr.ok"
OK="t-smtpa-0.ok"
OUT="t-smtpa-0.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
user+*:	local:
sender: local:
alias1: <user+alias1@local.dom> <user+alias2@local.dom> <user+alias3@local.dom> <user+alias4@local.dom>
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

TEST=1
# ----------------------------------------
# temporary failure from SMTP for all but first recipient

${CAT} > ${EDBROK} <<EOF
EOF

if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -1 -s 60 -Q '-P<bounce@y.z>' -i 4 -Y '-1 -L unix:lmtpsock' -O ${EDBROK} -E 10 -A 1 -X 4 -S"a1s1@b.c" -R"alias1@local.dom"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  rm -f ${ALIMAP}
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
