#!/bin/sh
# $Id: t-pmilter-11.sh,v 1.8 2005/10/19 18:34:53 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test pmilter restart
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
V=0

SCRIPTS=`cd ${SD} && pwd`

if ../smtps/smtps -VVV | ${GREP} SM_USE_PMILTER >/dev/null
then
  :
else
  echo "$0: smtps not compiled with SM_USE_PMILTER (--enable-pmilter); test SKIPPED"
  exit 0
fi

if test X"`uname`" = "XLinux"
then
  echo "$0: SKIPPED on Linux, needs POSIX conformant pthread implementation"
  exit 0
fi

OUT="t-pmilter-11.out"
PMPRG="-p ../libpmilter/t-pmilter-1"
PMOPT=""

if test X"`uname`" != "XOSF1"
then
while getopts O:p:s:V FLAG
do
  case "${FLAG}" in
    O) PMOPT="${PMOPT} ${OPTARG}";;
    p) PMPRG="-p ${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=unix; path="pmilter.sock";} timeout=2;
 flags=accept_but_reconnect;}
}
EOF

# ----------------------------------------
# reject mail command in pmilter, kill pmilter, send two more mails:
# the first one goes through because the MTA didn't reconnect yet,
# the second one is blocked because the MTA reconnected.
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
SENDER=a@b.c
RCPT=x@y.z
rm -f ${PMIDS}
PMOPTS="-r m=550"
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -V '-d 8' -z ${PMPRG} ${PMOPT} -P "${PMOPTS}" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S${SENDER} -R${RCPT}
then
  ERR=false

  # first mail rejected
  if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
  then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      echo "$0: test ${TEST} failed: err not found in ${PML}"
      ERR=true
    fi
  else
    echo "$0: test ${TEST} failed: MAIL=error not found in ${CLTL}"
    ERR=true
  fi

  if test -s ${PMIDS}
  then
    # kill pmilter and start new one
    kill -HUP `${CAT} ${PMIDS}`
    ../libpmilter/t-pmilter-1 ${PMOPT} ${PMOPTS} > m${V}.log 2>&1 &
    PMID=$!
    echo ${PMID} >> ${PIDS}
    echo ${PMID} >> ${PMIDS}

    sleep 1
    # send another message: should go through, not yet reconnected to pmilter
    if ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} > ${CLTL} 2>&1
    then
      if ${GREP} "total=1 " ${CLTL} >/dev/null
      then
       :
      else
        ERR=true
        echo "$0: test ${TEST} failed: total!=1"
      fi
    else
      ERR=true
      echo "$0: test ${TEST} failed: smtpc2:1"
    fi

    sleep 1
    # send another message: should be blocked, reconnected to pmilter
    if ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} > ${CLTL} 2>&1
    then
      if ${GREP} "total=0 " ${CLTL} >/dev/null
      then
        :
      else
        ERR=true
        echo "$0: test ${TEST} failed: total!=0"
        ${VERBOSE} && ${GREP} "total=" ${CLTL}
      fi
    else
      ERR=true
      echo "$0: test ${TEST} failed: smtpc2:2"
    fi

  else
    echo "$0: cannot find pmilter pid"
  fi
else
    ERR=true
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${PMIDS}

if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
${SD}/stopmts.sh
fi

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=unix; path="pmilter.sock";} timeout=2;
 flags=abort;}
}
EOF

# ----------------------------------------
# reject mail command in pmilter, kill pmilter, send two more mails:
# the first one is blocked even though the MTA didn't reconnect yet but "abort"
# is set,
# the second one is blocked because the MTA reconnected.
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
SENDER=a@b.c
RCPT=x@y.z
rm -f ${PMIDS}
PMOPTS="-r m=550"
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -z ${PMPRG} ${PMOPT} -P "${PMOPTS}" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S${SENDER} -R${RCPT}
then
  ERR=false

  if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
  then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      ERR=true
    fi
  else
    ERR=true
  fi

  if test -s ${PMIDS}
  then
    kill -HUP `${CAT} ${PMIDS}`
    ../libpmilter/t-pmilter-1 ${PMOPT} ${PMOPTS} > m${V}.log 2>&1 &
    PMID=$!
    echo ${PMID} >> ${PIDS}
    echo ${PMID} >> ${PMIDS}

    sleep 1
    if ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} >> ${CLTL} 2>&1
    then
      if ${GREP} "total=0 " ${CLTL} >/dev/null
      then
       :
      else
        ERR=true
        echo "$0: test ${TEST} failed: total!=0"
        ${VERBOSE} && ${GREP} "total=" ${CLTL}
      fi
    else
      ERR=true
      echo "$0: test ${TEST} failed: smtpc2 1"
    fi

    sleep 1
    if ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} >> ${CLTL} 2>&1
    then
      if ${GREP} "total=0 " ${CLTL} >/dev/null
      then
       :
      else
        ERR=true
        echo "$0: test ${TEST} failed: total=0"
        ${VERBOSE} && ${GREP} "total=" ${CLTL}
      fi
    else
      ERR=true
      echo "$0: test ${TEST} failed: smtpc2 2"
    fi

  else
    echo "$0: cannot find pmilter pid"
  fi
else
    ERR=true
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${PMIDS}

if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
${SD}/stopmts.sh
fi


# ----------------------------------------
# do not start pmilter, send two mails:
# the first one gets through as the MTA isn't connected
# but "accept_but_reconnect" is set,
# the second one is blocked because the MTA reconnected.
TEST=3
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=unix; path="pmilter.sock";} timeout=1;
 flags=accept_but_reconnect;}
}
EOF

SENDER=a@b.c
RCPT=x@y.z
rm -f ${PMIDS}
PMOPTS="-r m=550"
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -z -Z 'smtpc2' -c '-E' -E 1 -A 1 -X 1 $@ -S${SENDER} -R${RCPT}
then
  ERR=false

    if ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} >> ${CLTL} 2>&1
    then
      if ${GREP} "total=1 " ${CLTL} >/dev/null
      then
       :
      else
        ERR=true
        echo "$0: test ${TEST} failed: part 2"
      fi
    else
      ERR=true
      echo "$0: test ${TEST} failed: part 3"
    fi

    ../libpmilter/t-pmilter-1 ${PMOPT} ${PMOPTS} > m${V}.log 2>&1 &
    PMID=$!
    echo ${PMID} >> ${PIDS}

    sleep 1
    if ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} >> ${CLTL} 2>&1
    then
      if ${GREP} "total=0 " ${CLTL} >/dev/null
      then
       :
      else
        ERR=true
        echo "$0: test ${TEST} failed: total!=0"
        ${VERBOSE} && ${GREP} "total=" ${CLTL}
      fi
    else
      ERR=true
      echo "$0: test ${TEST} failed: part 5"
    fi

  if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
  then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      ERR=true
      echo "$0: test ${TEST} failed: part 6"
    fi
  else
    ERR=true
    echo "$0: test ${TEST} failed: part 7"
  fi

else
    ERR=true
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${PMIDS}

if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
${SD}/stopmts.sh
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
