#!/bin/sh
# $Id: t-pmilter-10.sh,v 1.5 2005/10/19 18:34:53 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test pmilter rejections including error text
# uses smtpcnf.sh.
# This is a variant of t-pmilter-4.sh using an inet socket.
# HACK: the error text uses '_' instead of spaces as long as I can't figure
# out how to pass a string with spaces in it via two shell scripts to
# t-pmilter-1. That program currently uses a hack to replace '_' with ' '.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if ../smtps/smtps -VVV | ${GREP} SM_USE_PMILTER >/dev/null
then
  :
else
  echo "$0: smtps not compiled with SM_USE_PMILTER (--enable-pmilter); test SKIPPED"
  exit 0
fi

OUT="t-pmilter-4.out"
PMPRG="-p ../libpmilter/t-pmilter-1"
PMOPT=""
PMSOCK="inet:2478@[127.0.0.1]"

if test X"`uname`" != "XOSF1"
then
while getopts O:p:s:V FLAG
do
  case "${FLAG}" in
    O) PMOPT="${PMOPT} ${OPTARG}";;
    p) PMPRG="-p ${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }

smtps {
Log_Level = 19;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=inet; port=2478; address=127.0.0.1;} timeout=2; }
}

EOF


# ----------------------------------------
# reject mail command in milter
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-r m=550 -R m=551_oops ${PMSOCK}" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'MAIL=error, text=551 oops' ${CLTL} >/dev/null
then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      ERR=true
    fi
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi


# ----------------------------------------
# reject rcpt command in milter
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-r r=550 -R r=552_5.7.1_rcpt ${PMSOCK}" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'RCPT=error, text=552 5.7.1 rcpt' ${CLTL} >/dev/null
then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      ERR=true
    fi
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi

# ----------------------------------------
# reject DATA command in milter
TEST=3
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-r d=550 -R d=553_5.7.2_data ${PMSOCK}" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'DATA=error, text=553 5.7.2 data,' ${CLTL} >/dev/null
then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      ERR=true
    fi
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi

# ----------------------------------------
# reject final dot command in milter
TEST=4
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-r b=550 -R b=553_5.7.3_dot ${PMSOCK}" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'DOT=error, text=553 5.7.3 dot,' ${CLTL} >/dev/null
then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      ERR=true
    fi
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
