#!/bin/sh
# $Id: t-mts-ocr-1.sh,v 1.13 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test outgoing connection restrictions.
# test idea:
# sink temporarily rejects mails for N seconds
# source sends many (100?) mails
# after a few attempts the concurrency goes to 0.
# send a signal to qmgr, smtpc, and sink to get the status
# and check it (no mails accepted).
# wait Ns (>= octo: connection cache timeout),
# send some mails again: system should start delivering mails
# set retry time such that it starts sending the mails from the first batch
# short after N seconds
# wait a few more second
# send a signal to qmgr, smtpc, and sink to get the status
# and check it (all mails accepted).
#
# uses mcpmts.sh,  to send mail: t-mts-ocr-snd-1.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`
I=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

# create directory to pass socket
if test -d smtps
then
  :
else
  mkdir smtps
fi

killit()
{
rm -f ${QMGRCONFMAP} ${MTMAP}
exit 1
}

# create restrictions
${CAT} > ${QMGRCONF} <<EOF
oci:10.1.1.2	10
ocm:10.1.1.2	100
octo:10.1.1.2	20
EOF
# create map
rm -f ${QMGRCONFMAP}
${MM} -t'	' -F ${QMGRCONFMAP} < ${QMGRCONF}
rm -f ${MTMAP}
trap killit 2

# ----------------------------------------
${CAT} >${SMXCNF} <<EOF
smtps { log_level = 14; pass_fd_socket = smtps/smtpsfd; wait_for_server=4;
	listen_socket { type=inet; port=${SRVPORT}; }
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -f ${SMXCNF} ${SM_SERVER_OPTIONS}";
}
smtpc { log_level = 14; remote_port = ${SNKPORT}; wait_for_server=4;
	connect_only_to = 127.0.0.1;
	io_timeout=60s;
	start_action = wait; user = ${USER};
	path = "../smtpc/smtpc"; arguments = "smtpc -f ${SMXCNF}";
}
qmgr { log_level = 14; wait_for_server=4; wait_for_client=4; 
	retry_min_delay = 30;
	start_action = wait; user = ${USER};
	# restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${SMXCNF} -d 2";
}
smar { log_level = 14;
	start_action = wait; user = ${USER};
	# restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${SMXCNF}";
}
EOF

${CAT} > ${MT} <<EOF
dom1.tld	[10.1.1.1]
dom2.tld	[10.1.1.2]
dom3.tld	[10.1.1.3]
dom4.tld	[10.1.1.4]
dom5.tld	[10.1.1.5]
dom6.tld	[10.1.1.6]
dom7.tld	[10.1.1.7]
dom8.tld	[10.1.1.8]
dom9.tld	[10.1.1.9]
EOF

for i in smar smtps smtpc qmgr
do
  cp /dev/null ${i}.log
done

# ----------------------------------------
# 
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

# program used to send mails
SM_SOURCE=${SD}/t-mts-ocr-snd-1.sh
export SM_SOURCE

# 
if ${SHELL} ${SD}/mcpmts.sh -Y '-o 20' -s 10 -A 50 -E 51
then
  if test X"${SRVL}" != "X" -a -s "${SRVL}"
  then
    # can be more than 20!
    ${GREP} 'Max busy threads  * 2[0-9]' ${SRVL} >/dev/null ## || ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && exit 1
else
  ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi


rm -f ${QMGRCONFMAP} f ${MTMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
