#!/bin/sh
# $Id: t-msg-ok-0.sh,v 1.11 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test whether message content has been transferred "OK"
# creates several message bodies with varying number of lines and
# compares the data stored in lmtpdir/ with the input.
# uses smtp1.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-msgok-0.ok"
OUT="t-msgok-0.out"
DATA="t-msgok-0.in"
STEP=98
LINE="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ
"
MAX_LINES=1000

if test X"`uname`" != "XOSF1"
then
while getopts L:M:S:s:V FLAG
do
  case "${FLAG}" in
    L) LINE="${OPTARG}";;
    M) MAX_LINES="${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    S) STEP="${OPTARG}";;
    V) VERBOSE=true;;
    ?)
       echo "$0: unknown option ${FLAG}"
       echo "$0: options:"
       echo "-L line    line to use in body of mail (must end with CRLF)"
       echo "-M n       use n as maximum number of lines [${MAX_LINES}]"
       echo "-s n       skip test number n"
       echo "-S n       increase number of lines by n [${STEP}]"
       exit 1
       ;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

LINES=10
TEST=0
FROM="From: sender@local.dom
"

while test ${LINES} -le ${MAX_LINES}
do

test -s stop && break

rm -f ${DATA}
echo ${FROM} > ${DATA}
${CAT} >> ${DATA} <<EOF
To: user@local.dom
Subject: test data

EOF
i=0
while test ${i} -le ${LINES}
do
  echo ${LINE} >> ${DATA}
  i=`expr ${i} + 1 `
done

# ----------------------------------------
TEST=`expr ${TEST} + 1 `
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtp1.sh -Z smtpc2 -c "-D ${DATA}" -3 lmtpsock -Ssender@local.dom -Ruser@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
     rm -f ${OK}
     ${CAT} ${DATA} >> ${OK}
     echo "
" >> ${OK}
     echo ".
" >> ${OK}

     rm -f ${OUT}
     echo ${FROM} >> ${OUT}
     ${EGREP} -v '^(Date|Return-Path): ' ${B1} |\
	 ${SED} -e '/^Received:/,/^From:/d' >> ${OUT}

    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
      ERR=true
    fi

  else
     ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
   break
elif ${VERBOSE}
then
   echo "$0: test ${TEST} OK"
fi
fi

LINES=`expr ${LINES} + ${STEP} `
done


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
