#!/bin/sh
# $Id: t-darestart-0.sh,v 1.12 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test killing and restarting a DA; check occ entries
# ----------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_SLOW_TEST}" != "X"
then
  echo "$0: SKIPPED due to SM_NO_SLOW_TEST"
  exit 0
fi

if test X"`uname`" = "XLinux"
then
  echo "$0: SKIPPED on Linux, needs POSIX conformant pthread implementation"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi

ERRS=0
OUT="t-darestart-0.out"
OUT1="t-darestart-0-1.out"
# debug flags
D="-d 7"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory
cd ../qmgr || exit 1
rm -f ${MTMAP}
# setup/initialize system
. ${SD}/mta-setup.sh
SRCPRG=${STE}/smtpc

rm -f ${QMGRCONFMAP} ${ALIMAP} ${ACCMAP} ${OUT} ${OUT1}

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `${CAT} ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi
if test X"${SRVPID}" != "X"
then
  kill -TERM ${SRVPID}
fi
exit 1
}

SRVPID=""
# start SMTP sink
${STE}/smtps2 -i -l . -w -40 -b ${H}:${SNKPORT} > ${SRVL} 2>&1 &
status=$?
SRVPID=$!
if test "x${status}" != "x0"
then
  echo "$0: FAIL: cannot start server ${status}"
  exit ${status}
fi
sleep 1


# version of output files
V=0
# path to programs
P=..
export P
rm -f ${PIDS}
trap killit 2 15

${P}/smar/smar ${D} > a${V}.log 2>&1 &
echo $! >> ${PIDS}
${P}/qmgr/qmgr -D 20 -w ${W4S} -W ${W4C} ${D} > q${V}.log 2>&1 &
QMGRPID=$!
echo $! >> ${PIDS}
${P}/smtpc/smtpc -v 12 -w ${W4S} -P ${SNKPORT} > c${V}.log 2>&1 &
SMTPCPID=$!
echo $! >> ${PIDS}
${P}/smtps/smtps -w ${W4S} ${D} -b localhost:${SRVPORT} > s${V}.log 2>&1 &
echo $! >> ${PIDS}

# check that the MTA is running
${CHKD}/mta-running.sh ${SRVPORT} || killit

# ----------------------------------------
# test: try to send a message, kill DA, send USR1 to qmgr, restart DA

TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

  if ${SRCPRG} -r ${H}:${SRVPORT} -f"s1@b.c" -R"r1@y.z" > ${CLTL} 2>&1
  then
    sleep 4
    kill -USR1 ${QMGRPID}
    sleep 1
    ${GREP} 'occ_ipv4=.* open_se=1, open_ta=1' q${V}.log > ${OUT}
    test -s ${OUT} || { echo "$0: no session open"; ERR=true; }
    kill ${SMTPCPID}
    sleep 3
    kill -USR1 ${QMGRPID}
    sleep 1
    ${GREP} 'occ_ipv4=.* open_se=0, open_ta=0' q${V}.log > ${OUT}
    test -s ${OUT} || { echo "$0: session not closed"; ERR=true; }
    ${P}/smtpc/smtpc -w ${W4S} -P ${SNKPORT} ${D} >> c${V}.log 2>&1 &
    SMTPCPID=$!
    echo $! >> ${PIDS}

    # enough time to deliver mail with new DA
    sleep 66

    # send SMTP server a signal to dump its state
    if kill -USR1 ${SRVPID}
    then
      :
    else
      echo "kill -USR1 failed: $?"
      exit 1
    fi
    sleep 2

    TRQS=1

    # the number of requests can vary based on the scheduler...
    RQS=`${GREP} "^Requests served *" ${SRVL} | head -1 | sed -e 's/^Requests served *//'`
    if test "${RQS}" -lt "${TRQS}"
    then
      echo "wrong number of requests: expected=${TRQS} got=${RQS}"
      ERR=true
    fi

    TR=2
    if egrep "^Recipients *${TR}$" ${SRVL} > /dev/null
    then
      :
    else
      echo "wrong number of recipients: expected=${TR}"
      ${GREP} "^Recipients" ${SRVL}
      ERR=true
    fi

    TA=1
    if egrep "^Transactions accepted *${TA}$" ${SRVL} > /dev/null
    then
      :
    else
      echo "wrong number of accepted transactions: expected=${TA}"
      ${GREP} "^Transactions accepted" ${SRVL}
      ERR=true
    fi

  else
    ${CAT} ${CLTL}
    ERR=true
  fi

if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
fi
fi

# ----------------------------------------
# stop system
if test -s ${PIDS}
then
  # stop MTA components
  for i in `${CAT} ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi
if test X"${SRVPID}" != "X"
then
  kill -TERM ${SRVPID}
fi
rm -f ${PIDS}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
