#!/bin/sh
# $Id: t-bounce-5.sh,v 1.17 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test bounces; including text of bounces delivered via lmtp to smtps3
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-bounce-5.ok"
OUT="t-bounce-5.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
451: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# get the directory from common.sh?
B2=lmtpdir/1/S000000000000000100
B1=lmtpdir/2/S000000000000000200

# ----------------------------------------
# test: 2 recipients (or more)
# 1. create a bounce and send it
# 2. deliver one message later on and check whether it actually contains
# a body (see qmgr/sched.c,1.156 -> 1.157)
#
# permanent failure from sink for one recipient,
# temporary, then permanent failure from sink another recipient
# check content

TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtp1.sh -s 30 -i 4 -3 lmtpsock -B '-o 10' -Q '-P<postmaster@local.dom>' -Ssender@local.dom -R"550@x.y -R451@local.dom" -E 1 -X 1 -A 1
then

  if test -s ${B1}
  then

${CAT} > ${OK} <<EOF
To: you
Subject: test

body
.
EOF

    ${SED} -e '1,/^From:/d' -e 's/
$//' ${B1} > ${OUT}
    if ${DIFF} -w ${OK} ${OUT}
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi

  if test -s ${B1}
  then

${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<550@x.y>
Remote-MTA: 127.0.0.1
Reason:
550 whatever
during RCPT


Your original mail follows:
EOF

     ${EGREP} -v '^Date: ' ${B2} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}
    if ${DIFF} -w ${OK} ${OUT}
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
