/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-strsplit.c,v 1.3 2004/12/26 04:08:54 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"

#include <stdio.h>

#define SMAXLEN	256

static void
test_harness(sm_rpool_P a)
{
	char *magic = "magica buf";
	sm_str_P s, left, right;
	sm_ret_T ret;

	s = sm_str_scpy0(a, magic, SMAXLEN);
	SM_TEST(s != NULL);
	if (s == NULL)
		return;
	left = sm_str_new(a, SMAXLEN, SMAXLEN);
	SM_TEST(left != NULL);
	if (left == NULL)
		return;
	right = sm_str_new(a, SMAXLEN, SMAXLEN);
	SM_TEST(right != NULL);
	if (right == NULL)
		return;

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) ' ', true, left, right);
	SM_TEST(ret > 0);
	SM_TEST(sm_str_getlen(left) == strlen("magica"));
	SM_TEST(sm_str_getlen(right) == strlen("buf"));

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) ' ', false, left, right);
	SM_TEST(ret > 0);
	SM_TEST(sm_str_getlen(left) == strlen("magica"));
	SM_TEST(sm_str_getlen(right) == strlen(" buf"));

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) 'x', true, left, right);
	SM_TEST(ret > 0);
	SM_TEST(sm_str_getlen(left) == 0);
	SM_TEST(sm_str_getlen(right) == 0);

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) 'x', false, left, right);
	SM_TEST(ret > 0);
	SM_TEST(sm_str_getlen(left) == 0);
	SM_TEST(sm_str_getlen(right) == 0);

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) 'm', true, left, right);
	SM_TEST(ret == 0);
	SM_TEST(sm_str_getlen(left) == 0);
	SM_TEST(sm_str_getlen(right) == sm_str_getlen(s) - 1);

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) 'm', false, left, right);
	SM_TEST(ret == 0);
	SM_TEST(sm_str_getlen(left) == 0);
	SM_TEST(sm_str_getlen(right) == sm_str_getlen(s));

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) 'a', true, left, right);
	SM_TEST(ret > 0);
	SM_TEST(sm_str_getlen(left) == 1);
	SM_TEST(sm_str_getlen(right) == sm_str_getlen(s) - 2);

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) 'a', false, left, right);
	SM_TEST(ret > 0);
	SM_TEST(sm_str_getlen(left) == 1);
	SM_TEST(sm_str_getlen(right) == sm_str_getlen(s) - 1);

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) 'f', true, left, right);
	SM_TEST(ret > 0);
	SM_TEST(sm_str_getlen(left) == sm_str_getlen(s) - 1);
	SM_TEST(sm_str_getlen(right) == 0);

	sm_str_clr(left);
	sm_str_clr(right);
	ret = sm_str_split(s, (uchar) 'f', false, left, right);
	SM_TEST(ret > 0);
	SM_TEST(sm_str_getlen(left) == sm_str_getlen(s) - 1);
	SM_TEST(sm_str_getlen(right) == 1);

	sm_str_free(left);
	sm_str_free(right);
	sm_str_free(s);
}

int
main(int argc, char *argv[])
{
	sm_rpool_P a;

	sm_test_begin(argc, argv, "test str1()");

	/* create an rpool for entire test */
	a = sm_rpool_new(NULL);
	SM_TEST(a != NULL);
	test_harness(a);
	sm_rpool_delete(a);

	/* test without rpool */
	test_harness(NULL);
	return sm_test_end();
}
