/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-streq.c,v 1.5 2004/09/09 01:37:29 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"

#include <stdio.h>

#define SMAXLEN	256

static void
test_harness(sm_rpool_P a)
{
	sm_str_P s;
	size_t len;
	char *src1 = "magic buf1";
	char *src2 = "mAgIc bUf2";

	s = sm_str_scpy(a, src1, SMAXLEN);
	SM_TEST(s != NULL);
	if (s == NULL)
		return;
	len = sm_str_getlen(s);
	SM_TEST(len == strlen(src1));
	SM_TEST(len > 1);
	if (len <= 1)
		return;

	SM_TEST(!sm_memncaseeq((void *) sm_str_getdata(s), len - 1,
			(void *) src1, len));
	SM_TEST(sm_memncaseeq((void *) sm_str_getdata(s), len - 1,
			(void *) src1, len - 1));
	SM_TEST(sm_memncaseeq((void *) sm_str_getdata(s), len - 1,
			(void *) src2, len - 1));
	SM_TEST(sm_memncaseeq((void *) sm_str_getdata(s), len,
			(void *) src1, len));
	SM_TEST(!sm_memncaseeq((void *) sm_str_getdata(s), len,
			(void *) src2, len));

	SM_TEST(sm_memcaseeq((void *) sm_str_getdata(s), (void *) src1,
			len - 1));
	SM_TEST(sm_memcaseeq((void *) sm_str_getdata(s), (void *) src2,
			len - 1));
	SM_TEST(sm_memcaseeq((void *) sm_str_getdata(s), (void *) src1, len));
	SM_TEST(!sm_memcaseeq((void *) sm_str_getdata(s), (void *) src2, len));

	SM_TEST(sm_memeq((void *) sm_str_getdata(s), (void *) src1,
			len - 1));
	SM_TEST(!sm_memeq((void *) sm_str_getdata(s), (void *) src2,
			len - 1));

	sm_str_free(s);
}

int
main(int argc, char *argv[])
{
	sm_rpool_P a;

	sm_test_begin(argc, argv, "test str case eq");
	a = sm_rpool_new(NULL);
	SM_TEST(a != NULL);
	test_harness(a);
	sm_rpool_delete(a);
	test_harness(NULL);
	return sm_test_end();
}
