/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-str2args.c,v 1.3 2005/06/02 19:00:33 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"

#include <stdio.h>

#define SMAXLEN	256
#define MAXARGS 8

static void
test_harness(sm_rpool_P a)
{
	sm_str_P s;
	sm_ret_T ret;
	uint argnames[MAXARGS];
	uint argvalues[MAXARGS];
	int args, maxargs;

			/*   01234567890123456789 */
	s = sm_str_scpy0(a, "field1=value1 f2=v2", SMAXLEN);
	SM_TEST(s != NULL);
	if (s == NULL)
		return;
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == 2);
	SM_TEST(argnames[0] == 0);
	SM_TEST(argnames[1] == 14);
	SM_TEST(argvalues[0] == 7);
	SM_TEST(argvalues[1] == 17);

	sm_str_clr(s);
	ret = sm_str_scat0(s, "field1=value1 f2=v2 ");
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(s != NULL);
	if (s == NULL)
		return;
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == 2);
	SM_TEST(argnames[0] == 0);
	SM_TEST(argnames[1] == 14);
	SM_TEST(argvalues[0] == 7);
	SM_TEST(argvalues[1] == 17);

	sm_str_clr(s);
	ret = sm_str_scat0(s, "field1=value1 f2=v2");
	maxargs = 1;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == sm_err_perm(E2BIG));
	if (args != sm_err_perm(E2BIG))
		fprintf(stderr, "args=%x, expected=%x\n", args,
			sm_err_perm(E2BIG));

	sm_str_clr(s);
	ret = sm_str_scat0(s, "f1= v1");
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == sm_err_perm(EINVAL));

	sm_str_clr(s);
	ret = sm_str_scat0(s, "f1 =v1");
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == sm_err_perm(EINVAL));

	sm_str_clr(s);
	ret = sm_str_scat0(s, "f1=");
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == sm_err_perm(EINVAL));

	sm_str_clr(s);
	ret = sm_str_scat0(s, "=v1");
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == sm_err_perm(EINVAL));

	sm_str_clr(s);
	ret = sm_str_scat0(s, "=f1=");
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == sm_err_perm(EINVAL));

	sm_str_clr(s);
	ret = sm_str_scat0(s, "f1=v1    ");
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == 1);

	sm_str_clr(s);
	ret = sm_str_scat0(s, "f1-/2=v1\\//!@#$%^&*()_-+=|~`[]{};:\"'<>,./?");
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == 1);

	sm_str_clr(s);
	ret = sm_str_scat0(s, "f1=v1\001");
	maxargs = MAXARGS;
	args = sm_str2args(s, 0, maxargs, argnames, argvalues);
	SM_TEST(args == sm_err_perm(EINVAL));

#if 0
	sm_str_clr(s);
	ret = sm_str_scat0(s, "this   is   a   buf");
	SM_TEST(ret == SM_SUCCESS);
	if (s == NULL)
		return;
	maxargs = MAXARGS;
	args = sm_str2argv(s, 0, maxargs, argv);
	SM_TEST(args == 4);
	SM_TEST(argv[0] == 0);
	SM_TEST(argv[1] == 7);
	SM_TEST(argv[2] == 12);
	SM_TEST(argv[3] == 16);
	SM_TEST(argv[4] == 0);

	sm_str_clr(s);
	ret = sm_str_scat0(s, "this is a buf\r\n");
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(s != NULL);
	if (s == NULL)
		return;
	maxargs = MAXARGS;
	args = sm_str2argv(s, 0, maxargs, argv);
	SM_TEST(args == 4);
	SM_TEST(argv[0] == 0);
	SM_TEST(argv[1] == 5);
	SM_TEST(argv[2] == 8);
	SM_TEST(argv[3] == 10);
	SM_TEST(argv[4] == 0);
#endif /* 0 */

	sm_str_free(s);
}

int
main(int argc, char *argv[])
{
	sm_rpool_P a;

	sm_test_begin(argc, argv, "test str2argv()");

	/* create an rpool for entire test */
	a = sm_rpool_new(NULL);
	SM_TEST(a != NULL);
	test_harness(a);
	sm_rpool_delete(a);

	/* test without rpool */
	test_harness(NULL);
	return sm_test_end();
}
