/*
 * Copyright (c) 2002, 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-stdio-3.c,v 1.5 2003/05/28 22:48:54 ca Exp $")
#include "sm/io.h"
#include "sm/test.h"
#include <stdio.h>

#define SM_N_CHARS	1024

int
main(int argc, char *argv[])
{
	int c, r;
	sm_ret_T res;
	sm_file_T *fp;

	sm_test_begin(argc, argv, "test sm_io errors");
	res = sm_io_open(SmStStdio, "foo", SM_IO_WRONLY, &fp, SM_IO_WHAT_END);
	SM_TEST(res == SM_SUCCESS);
	SM_TEST(fp != NULL);
	if (fp != NULL)
	{
		/* Error: file only open for write */
		c = sm_io_getc(fp);
#if 0
		SM_TEST(c == SM_IO_EOF);
		if (c != SM_IO_EOF)
			sm_io_fprintf(smioerr, "c=%x\n", c);
#endif /* 0 */
		SM_TEST(sm_is_err(c));
		c = 'A';
		r = sm_io_putc(fp, c);
		SM_TEST(r == c);
		res = sm_io_close(fp);
		SM_TEST(res == SM_SUCCESS);
		res = sm_io_open(SmStStdio, "foo", SM_IO_RDONLY, &fp, SM_IO_WHAT_END);
		SM_TEST(res == SM_SUCCESS);
		SM_TEST(fp != NULL);
		if (fp != NULL)
		{
			r = sm_io_putc(fp, c);
			SM_TEST(r != c);
			r = sm_io_getc(fp);
			SM_TEST(r == c);
			c = 'b';
			r = sm_io_ungetc(fp, c);
			SM_TEST(r != c);
			res = sm_io_close(fp);
			SM_TEST(res == SM_SUCCESS);
		}
	}
	return sm_test_end();
}
