/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-stdio-0.c,v 1.6 2002/09/19 21:41:04 ca Exp $")
#include "sm/io.h"
#include "sm/test.h"
#include <stdio.h>

int
main(int argc, char *argv[])
{
	sm_ret_T res;
	ssize_t n;
	sm_file_T *fp;
	int r, m;
	char *str = "foo\n";
	uchar in[16];

	sm_test_begin(argc, argv, "test sm_io_open");
	res = sm_io_open(SmStStdio, "foo", SM_IO_WRONLY, &fp, SM_IO_WHAT_END);
	SM_TEST(res == SM_SUCCESS);
	SM_TEST(fp != NULL);
	if (fp != NULL)
	{
		r = sm_io_getinfo(fp, SM_IO_IS_READABLE, &m);
		SM_TEST(r <= 0);
		res = sm_io_write(fp, (uchar *) str, (size_t)4, &n);
		SM_TEST(res == SM_SUCCESS);
		SM_TEST(n == 4);
		r = sm_io_getinfo(fp, SM_IO_WHAT_MODE, &m);
		SM_TEST(r == 0);
		SM_TEST(m == SM_IO_WRONLY);
		res = sm_io_close(fp);
		SM_TEST(res == SM_SUCCESS);
		res = sm_io_open(SmStStdio, "foo", SM_IO_RDONLY, &fp, SM_IO_WHAT_END);
		SM_TEST(res == SM_SUCCESS);
		SM_TEST(fp != NULL);
		if (fp != NULL)
		{
			r = sm_io_getinfo(fp, SM_IO_IS_READABLE, &m);
			SM_TEST(r > 0);
			res = sm_io_read(fp, in, (size_t)4, &n);
			SM_TEST(res == SM_SUCCESS);
			SM_TEST(n == 4);
			SM_TEST(strncmp(str, (char *) in, 4) == 0);
			r = sm_io_getinfo(fp, SM_IO_WHAT_MODE, &m);
			SM_TEST(r == 0);
			SM_TEST(m == SM_IO_RDONLY);
			res = sm_io_close(fp);
			SM_TEST(res == SM_SUCCESS);
		}
	}
	return sm_test_end();
}
