/*
 * Copyright (c) 2001, 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-scanf.c,v 1.10 2005/04/14 17:14:02 ca Exp $")
#include "sm/types.h"
#include "sm/io.h"
#include "sm/test.h"
#include "sm/limits.h"
#include "sm/string.h"
#include <stdio.h>

static void
testd(void)
{
	int i, d, h;
	bool rep;
	char buf[256];
	char str[256];

	rep = false;
	for (i = -32767; i < 32768; i++)
	{
		d = sm_snprintf(buf, sizeof(buf), "%d", i);
		SM_TEST(d == (int) strlen(buf));
#if HAVE_SNPRINTF
		snprintf(str, sizeof(str), "%d", i);
		if (!SM_TEST(strcmp(buf, str) == 0) && !rep)
		{
			fprintf(stderr, "expected '%s' got '%s' instead\n",
				str, buf);
			rep = true;
		}
		else
#endif /* HAVE_SNPRINTF */
		{
			d = sm_io_sscanf(buf, "%d", &h);
			SM_TEST(d == 1);
			SM_TEST(h == i);
		}
	}
}

static void
testld(long step)
{
	long i, h;
	int d;
	bool rep;
	char buf[256];
	char str[256];

	rep = false;
	for (i = LONG_MIN; i <= LONG_MAX - step; i += step)
	{
		d = sm_snprintf(buf, sizeof(buf), "%ld", i);
		SM_TEST(d == (int) strlen(buf));
#if HAVE_SNPRINTF
		snprintf(str, sizeof(str), "%ld", i);
		if (!SM_TEST(strcmp(buf, str) == 0) && !rep)
		{
			fprintf(stderr, "expected '%s' got '%s' instead\n",
				str, buf);
			rep = true;
		}
		else
#endif /* HAVE_SNPRINTF */
		{
			d = sm_io_sscanf(buf, "%ld", &h);
			SM_TEST(d == 1);
			SM_TEST(h == i);
		}
	}
}

static void
testscan2(char *in)
{
	int i;
	uint l1, l2;

	i = sm_io_sscanf(in, "%8X%4X", &l1, &l2);
	SM_TEST(i == 2);
	sm_io_fprintf(smioerr, "l1=%X, l2=%X\n", l1, l2);
}

static void
testscan64(void)
{
	int i;
	uint j, l1, l2;
	uint list[] = { 0, 1, 16, 31, 32, 63, 64, 127, 128, 255, 256,
		1023, 1024, 4095, 4096, 0x7FFFFFFF, 0xFFFFFFFF };
	char buf[16];

	for (j = 0; j < SM_ARRAY_SIZE(list); j++)
	{
		l1 = list[j];
		i = sm_snprintf(buf, sizeof(buf), "%Y", l1);
		i = sm_io_sscanf(buf, "%Y", &l2);
		SM_TEST(i == 1);
		SM_TEST(l1 == l2);
	}
}

int
main(int argc, char *argv[])
{
	int c;
	int i, d, h;
	long step;
	char buf[128];
	char *r;

	step = 123457;
	if (LONG_MAX / step > 100000)
		step = LONG_MAX / 100007;
	while ((c = getopt(argc, argv, "2:fhs:v")) != -1)
	{
		switch (c)
		{
		  case '2':
			testscan2(optarg);
			return 0;
		  case 'f':
			step = 1;
			break;
		  case 's':
			step = atol(optarg);
			break;
		}
	}
	sm_test_begin(argc, argv, "test scanf point stuff");

	d = 2;
	sm_snprintf(buf, sizeof(buf), "%d", d);
	r = "2";
	if (!SM_TEST(strcmp(buf, r) == 0))
		fprintf(stderr, "expected '2' got '%s' instead\n", buf);

	i = sm_io_sscanf(buf, "%d", &h);
	SM_TEST(i == 1);
	if (!SM_TEST(h == 2))
	{
#if !SM_CONF_BROKEN_SIZE_T
	printf("Check whether size_t is signed on your OS.\n\
If that is the case, add -DSM_CONF_BROKEN_SIZE_T to confENVDEF\n\
and start over. Otherwise contact sendmail.org.\n");
#endif /* !SM_CONF_BROKEN_SIZE_T */
	}

	d = 2;
	h = sm_snprintf(buf, sizeof(buf), "%d\n", d);
	r = "2\n";
	if (!SM_TEST(strcmp(buf, r) == 0))
		fprintf(stderr, "expected '2\n' got '%s' instead [%d]\n",
			buf, h);

	i = sm_io_sscanf(buf, "%d", &h);
	SM_TEST(i == 1);
	SM_TEST(h == 2);

	testd();
	testld(step);
	testscan64();
	return sm_test_end();
}
