/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-rcb-0.c,v 1.16 2004/09/09 01:37:29 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"
#include "sm/rcb.h"

#include <stdio.h>

#define INITLEN	16
#define SMAXLEN	260
#define LB 12345
#define LE 32767
#define LS 1234
#define ULB ((uint64_t) UINT32_MAX - (uint64_t) 255)
#define ULE ((uint64_t) UINT32_MAX + (uint64_t) 32767)
#define ULS ((uint64_t) 12345)

static void
test_harness(sm_rpool_P a)
{
	sm_rcb_P s;
	int i, v;
	uint32_t ui, ui1, ui2;
	uint64_t ul, ulr;
	size_t len, steps;
	sm_ret_T r;
	sm_str_P str;
	uchar buf[1024];
	char *magic = "magic buf";

	str = NULL;
	ul = (uint64_t) UINT32_MAX + (uint64_t) 255;
	SM_TEST(ul > (uint64_t) UINT32_MAX);
	s = sm_rcb_new(a, INITLEN, SMAXLEN);
	SM_TEST(s != NULL);
	if (s == NULL)
		goto end;
	i = 123;
	r = sm_rcb_open_enc(s, SMAXLEN);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_putuint32(s, 0);	/* dummy for record size */
	SM_TEST(r == SM_SUCCESS);
	r = sm_rcb_putuint32(s, i);
	SM_TEST(r == SM_SUCCESS);
	r = sm_rcb_putuint64(s, ul);
	SM_TEST(r == SM_SUCCESS);
	r = sm_rcb_put3uint64(s, 1, 2, ul);
	SM_TEST(r == SM_SUCCESS);
	r = sm_rcb_close_enc(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	r = sm_rcb_open_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_getuint32(s, &ui);	/* record size */
	SM_TEST(r == SM_SUCCESS);
	r = sm_rcb_getuint32(s, &ui);
	SM_TEST(r == SM_SUCCESS);
	SM_TEST(i == ui);
	r = sm_rcb_getuint64(s, &ulr);
	SM_TEST(r == SM_SUCCESS);
	SM_TEST(ul == ulr);
	r = sm_rcb_get3uint64(s, &ui1, &ui2, &ulr);
	SM_TEST(r == SM_SUCCESS);
	SM_TEST(ui1 == 1);
	SM_TEST(ui2 == 2);
	SM_TEST(ul == ulr);
	SM_TEST(SM_RCB_ISEOB(s));
	r = sm_rcb_close_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	/* put/getuint32 */
	r = sm_rcb_open_enc(s, SMAXLEN);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_putuint32(s, 0);	/* dummy for record size */
	SM_TEST(r == SM_SUCCESS);

	/* steps = 1 for record size */
	for (steps = 1, i = LB; i < LE; i += LS, steps++)
	{
		r = sm_rcb_putuint32(s, i);
		SM_TEST(r == SM_SUCCESS);
		if (r != SM_SUCCESS)
			goto end;
	}
	len = sm_rcb_getlen(s);
	SM_TEST(len == steps * sizeof(int));
	r = sm_rcb_close_enc(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	r = sm_rcb_open_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_getuint32(s, &ui);	/* record size */
	SM_TEST(r == SM_SUCCESS);
	for (i = LB; i < LE; i += LS)
	{
		SM_TEST(r == SM_SUCCESS);
		r = sm_rcb_getuint32(s, &ui);
		SM_TEST(r == SM_SUCCESS);
		if (r != SM_SUCCESS)
			goto end;
		SM_TEST(i == ui);
	}

	/* exceed space */
	r = sm_rcb_putinit(s, SMAXLEN);
	SM_TEST(r == SM_SUCCESS);
	for (steps = 0, i = 0; i < LE; i++, steps++)
	{
		r = sm_rcb_putuint32(s, i);
		if (steps * sizeof(int) >= SMAXLEN)
		{
			SM_TEST(r != SM_SUCCESS);
			break;
		}
		else
			SM_TEST(r == SM_SUCCESS);
	}
	SM_TEST(r != SM_SUCCESS);
	r = sm_rcb_close_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	/* put/getuint64 */
	r = sm_rcb_open_enc(s, SMAXLEN);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_putuint32(s, 0);	/* dummy for record size */
	SM_TEST(r == SM_SUCCESS);

	/* steps = 1 for record size */
	for (steps = 1, ul = ULB; ul < ULE; ul += ULS, steps++)
	{
		r = sm_rcb_put3uint64(s, 3, 5, ul);
		SM_TEST(r == SM_SUCCESS);
		if (r != SM_SUCCESS)
			goto end;
	}
	len = sm_rcb_getlen(s);

	/*
	**  expected length:
	**  steps - 1 records of 2 uint32 + 1 uint64
	**  plus uint32 (initial length)
	*/

	v = 2 * (steps - 1) * sizeof(uint32_t) + (steps - 1) * sizeof(uint64_t)
		+ sizeof(uint32_t);
	SM_TEST(len == v);
	r = sm_rcb_close_enc(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	r = sm_rcb_open_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_getuint32(s, &ui);	/* record size */
	SM_TEST(r == SM_SUCCESS);
	for (ul = ULB; ul < ULE; ul += ULS)
	{
		SM_TEST(r == SM_SUCCESS);
		r = sm_rcb_get3uint64(s, &ui1, &ui2, &ulr);
		SM_TEST(r == SM_SUCCESS);
		SM_TEST(ui1 == 3);
		SM_TEST(ui2 == 5);
		if (r != SM_SUCCESS)
			goto end;
		SM_TEST(ul == ulr);
	}
	r = sm_rcb_close_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	/* put/get (char) */
	r = sm_rcb_open_enc(s, SMAXLEN);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_putuint32(s, 0);	/* dummy for record size */
	SM_TEST(r == SM_SUCCESS);
	for (i = 0; i < 256; i++)
	{
		r = SM_RCB_PUT(s, i);
		SM_TEST(r == SM_SUCCESS);
		if (r != SM_SUCCESS)
			goto end;
	}
	r = sm_rcb_close_enc(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	r = sm_rcb_open_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_getuint32(s, &ui);	/* record size */
	SM_TEST(r == SM_SUCCESS);
	for (i = 0; i < 256; i++)
	{
		v = SM_RCB_GET(s);
		SM_TEST(i == v);
	}
	SM_TEST(SM_RCB_ISEOB(s));
	r = sm_rcb_close_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	/* put/getrcb */
	len = SM_ALIGN4_SIZE(strlen(magic));
	v = SMAXLEN / len;
	r = sm_rcb_open_enc(s, -1);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_putuint32(s, 0);	/* dummy for record size */
	SM_TEST(r == SM_SUCCESS);
	for (i = 0; i < v; i++)
	{
		r = sm_rcb_putn(s, (uchar *) magic, len);
		SM_TEST(r == SM_SUCCESS);
		if (r != SM_SUCCESS)
			goto end;
	}
	r = sm_rcb_putn(s, (uchar *) magic, len);
	SM_TEST(r != SM_SUCCESS);
	r = sm_rcb_close_enc(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	r = sm_rcb_open_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_getuint32(s, &ui);	/* record size */
	SM_TEST(r == SM_SUCCESS);
	for (i = 0; i < v; i++)
	{
		r = sm_rcb_getn(s, buf, len);
		SM_TEST(r == SM_SUCCESS);
		if (r != SM_SUCCESS)
			goto end;
		SM_TEST(sm_memeq((void *) buf, (void *) magic, len));
	}
	SM_TEST(SM_RCB_ISEOB(s));
	r = sm_rcb_close_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	len = SM_ALIGN4_SIZE(strlen(magic));
	r = sm_rcb_open_enc(s, SMAXLEN);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_putuint32(s, 0);	/* dummy for record size */
	SM_TEST(r == SM_SUCCESS);
	r = sm_rcb_putuint32(s, len);
	SM_TEST(r == SM_SUCCESS);
	r = sm_rcb_putn(s, (uchar *) magic, len);
	SM_TEST(r == SM_SUCCESS);
	r = sm_rcb_close_enc(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;

	r = sm_rcb_open_dec(s);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	r = sm_rcb_getuint32(s, &ui);	/* record size */
	SM_TEST(r == SM_SUCCESS);
	r = sm_rcb_getuint32(s, &ui);
	SM_TEST(r == SM_SUCCESS);
	SM_TEST(SM_ALIGN4_SIZE(len) == ui);
	r = sm_rcb_getnstr(s, &str, ui);
	SM_TEST(r == SM_SUCCESS);
	if (r != SM_SUCCESS)
		goto end;
	SM_TEST(sm_memeq((void *) magic, (void *) sm_str_data(str), len));
	SM_TEST(sm_str_getlen(str) >= len);
	SM_TEST(sm_str_getlen(str) == ui);
	SM_TEST(SM_RCB_ISEOB(s));
	r = sm_rcb_close_dec(s);
	SM_TEST(r == SM_SUCCESS);

  end:
	SM_STR_FREE(str);
	SM_RCB_FREE(s);
}

int
main(int argc, char *argv[])
{
	sm_rpool_P a;

	sm_test_begin(argc, argv, "test rcb");

	/* create an rpool for entire test */
	a = sm_rpool_new(NULL);
	SM_TEST(a != NULL);
	test_harness(a);
	sm_rpool_delete(a);

	/* test without rpool */
	test_harness(NULL);
	return sm_test_end();
}
