/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-fxszq.c,v 1.7 2004/12/29 23:47:29 ca Exp $")
#include "sm/assert.h"
#include "sm/heap.h"
#include "sm/test.h"
#include "sm/fxszq.h"

#include <stdio.h>

struct fxszq_S
{
	uint	 fsq_max;   /* allocated size */
	uint	 fsq_cur;   /* currently used (basically last-first) */
	uint	 fsq_first; /* first index to read */
	uint	 fsq_last;  /* last index to read (first to write) */
	int	*fsq_array; /* array */
};

typedef struct fxszq_S	fxszq_T, *fxszq_P;

static void
test_lists(uint sz)
{
	int i, j;
	uint h;
	fxszq_T q1;

	SM_TEST(sz != 0);
	if (sz == 0)
		return;
	q1.fsq_array = sm_malloc(sizeof(int) * sz);
	SM_TEST(q1.fsq_array != NULL);
	if (q1.fsq_array == NULL)
		return;
	FSQ_INIT(sz, q1.fsq_max, q1.fsq_cur, q1.fsq_first, q1.fsq_last);
	SM_TEST(FSQ_IS_EMPTY(q1.fsq_cur));
	SM_TEST(!FSQ_IS_FULL(q1.fsq_max, q1.fsq_cur));
	for (i = 0; i < sz; i++)
	{
		FSQ_APPEND(q1.fsq_max, q1.fsq_last, q1.fsq_cur, q1.fsq_array, i);
		SM_TEST(!FSQ_IS_EMPTY(q1.fsq_cur));
		if (i < sz - 1)
			SM_TEST(!FSQ_IS_FULL(q1.fsq_max, q1.fsq_cur));
		else
			SM_TEST(FSQ_IS_FULL(q1.fsq_max, q1.fsq_cur));
	}
	for (i = 0; i < sz; i++)
	{
		j = FSQ_GET(q1.fsq_max, q1.fsq_first, q1.fsq_cur, q1.fsq_array, h);
		SM_TEST(i == j);
		SM_TEST(!FSQ_IS_FULL(q1.fsq_max, q1.fsq_cur));
		if (i < sz - 1)
			SM_TEST(!FSQ_IS_EMPTY(q1.fsq_cur));
		else
			SM_TEST(FSQ_IS_EMPTY(q1.fsq_cur));
	}
	sm_free(q1.fsq_array);
}

static void
usage(const char *prg)
{
	fprintf(stderr, "usage: %s [options]\n", prg);
	exit(0);
}

int
main(int argc, char *argv[])
{
	uint sz;
	int c;
	char *prg;

	prg = argv[0];
	sz = 0;
	while ((c = getopt(argc, argv, "s:")) != -1)
	{
		switch (c)
		{
		  case 's':
			sz = atoi(optarg);
			break;
		  default:
			usage(prg);
		}
	}
	sm_test_begin(argc, argv, "test fxszq");
	argc -= optind;
	argv += optind;
	if (sz == 0)
	{
		test_lists(8);
		test_lists(9);
		test_lists(13);
		test_lists(32);
	}
	else
	{
		test_lists(sz);
	}
	return sm_test_end();
}
