/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: decode-error.c,v 1.17 2005/07/01 20:29:28 ca Exp $")

#include <stdio.h>

#include "sm/error.h"
#include "sm/dns.h"
#include "sm/bdb.h"
#include "sm/rfc2821.h"

static int Verbose = 0;

static void
decode_error(sm_error_T err)
{
	int eno, module;
	char *errtxt;

	eno = sm_error_value(err);
	module = sm_error_module(err);

	if (Verbose > 0)
	{
		printf("error=%#x, mod=%d, type=%d, value=%d\n",
			err,
			module,
			sm_error_type(err),
			eno);
	}
	printf("type=%s\n",
		sm_is_temp_err(err) ? "TEMP" :
		sm_is_perm_err(err) ? "PERM" :
		sm_is_warn_err(err) ? "WARN" :
		sm_is_ok(err) ? "OK" : "?");
	errtxt = smmod2txt(err);
	printf("module=%s\n", errtxt == NULL ? "UNKNOWN" : errtxt);

	errtxt = smerr2txt(err);
	printf("error=%s\n", errtxt == NULL ? "UNKNOWN" : errtxt);
}

int
main(int argc, char *argv[])
{
	int i;

	while ((i = getopt(argc, argv, "V")) != -1)
	{
		switch (i)
		{
		  case 'V':
			++Verbose;
			break;
		}
	}
	argc -= optind;
	argv += optind;
	for (i = 0; i < argc; i++)
	{
		if (Verbose > 1)
			printf("in=%s ", argv[i]);
		decode_error((sm_error_T) strtoul(argv[i], (char **)NULL, 0));
	}
	return 0;
}
