/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: b-snprintf.c,v 1.2 2002/10/22 18:52:02 ca Exp $")

#include "sm/limits.h"
#include "sm/io.h"
#include "sm/types.h"
#include "sm/mta.h"
#include <stdio.h>
#include "timing.h"

/*
**  test sm_snprintf/snprintf performance
*/

#define PROCID(j)	((j) & 0x00ff)

void
test(int l)
{
	int i, j;
	char buf[SMTP_STID_SIZE];
	id_count_T id;

	START();
	id = 0;
	for (j = 0; j < l; j++)
	{
		i = sm_snprintf(buf, sizeof(buf), SMTPS_STID_FORMAT,
				id, PROCID(j));
		++id;
	}
	END();
	printf("time for %d iterations of sm_snprintf: ", l);
	DONE();
}

#if HAVE_SNPRINTF
void
test2(int l)
{
	int i, j;
	char buf[SMTP_STID_SIZE];
	id_count_T id;

	START();
	id = 0;
	for (j = 0; j < l; j++)
	{
		i = snprintf(buf, sizeof(buf), SMTPS_STID_FORMAT,
				id, PROCID(j));
		++id;
	}
	END();
	printf("time for %d iterations of snprintf:    ", l);
	DONE();
}
#endif /* HAVE_SNPRINTF */


int
main(int argc, char *argv[])
{
	int l;
	int c;

	l = 100000;
	while ((c = getopt(argc, argv, "l:")) != -1)
	{
		switch (c)
		{
		  case 'l':
			l = atoi(optarg);
			break;
		  default:
			/* usage(argv[0]); */
			return(1);
		}
	}
	Timing = true;
#if HAVE_SNPRINTF
	test2(l);
#endif /* HAVE_SNPRINTF */
	test(l);
	return 0;
}
