/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: log.h,v 1.7 2005/06/16 00:39:09 ca Exp $
 */

#ifndef SMTPC_LOG_H
#define SMTPC_LOG_H 1

#include "sm/generic.h"
#include "sm/log.h"

#if SMTPC_LOG_DEFINES
sm_logcategory_T sc_lcats[] =
{
	{ "init",	0 },
	{ "config",	0 },
	{ "client",	0 },
	{ "internal",	0 },
	{ "comm",	0 },
	{ NULL,		0 }
};

sm_logmodule_T sc_lmods[] =
{
	{ "smtpc/to_qmgr",	0 },
	{ "smtpc/from_qmgr",	0 },
	{ "smtpc/config",	0 },
	{ "smtpc/client",	0 },
	{ "smtpc/internal",	0 },
	{ "smtpc/comm",		0 },
	{ "smtpc/signal",	0 },
	{ NULL,			0 }
};

#else /* SMTPC_LOG_DEFINES */

/* should these be global or per sc context? */
extern sm_logcategory_T sc_lcats[];
extern sm_logmodule_T sc_lmods[];

#endif /* SMTPC_LOG_DEFINES */

#define SC_LCAT_INIT	(&sc_lcats[0])
#define SC_LCAT_CONFIG	(&sc_lcats[1])
#define SC_LCAT_CLIENT	(&sc_lcats[2])
#define SC_LCAT_INTERN	(&sc_lcats[3])
#define SC_LCAT_COMM	(&sc_lcats[4])

/* Backwards compatibility. */
#define SC_LCAT_GENERAL	SM_LOGCATEGORY_GENERAL

#define SC_LMOD_TO_QMGR		(&sc_lmods[0])
#define SC_LMOD_FROM_QMGR	(&sc_lmods[1])
#define SC_LMOD_CONFIG		(&sc_lmods[2])
#define SC_LMOD_CLIENT		(&sc_lmods[3])
#define SC_LMOD_INTERN		(&sc_lmods[4])
#define SC_LMOD_COMM		(&sc_lmods[5])
#define SC_LMOD_SIGNAL		(&sc_lmods[6])

void	 sc_log_init(sm_log_ctx_P _lctx);
void	 sc_log_setcontext(sm_log_ctx_P _lctx);

#endif /* SMTPC_LOG_H */
