#!/bin/sh
# $Id: t-smar.sh,v 1.15 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test MX/A expansion for RFC2821 addresses.
# Uses smar, t-smar-1, startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "$0: SKIPPED"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=smar.out
IP=smar.ip
OK=smar.ok
TPRG=./t-smar-1
rm -f ${SOCK} ${PIDS}
OKR=""
if test $# -ge 3 -a X"$1" = "X-e"
then
  OKR="$2"
  shift 2
fi

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1

rm -f ${OUT} ${IP}

# ----------------------------------------
# check output somehow...
${VALGRIND} ${TPRG} -VV $@ > ${OUT} 2>&1

egrep '^(IP|ERROR|WARN)' ${OUT} > ${IP}
if test X"${OKR}" != "X"
then
  egrep "${OKR}" ${IP} >/dev/null
else
  diff ${OK} ${IP}
fi
ok=$?

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

grep ERROR a.log

exit ${ok}
