#!/bin/sh
# $Id: t-smar-4.sh,v 1.8 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test CNAME/MX/A expansion for RFC2821 addresses.
# Uses smar, t-smar-2, startsmar.sh, DNS
# Note: this program relies on the sm9.org DNS server.
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=smar-4.out
IP=smar-4.ip
OK=smar-4.ok
TPRG=./t-smar-1
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${SOCK} ${PIDS}
# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -VVVV '<a@cname1.sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} > ${IP}
cat > ${OK} <<EOF
IP[0]=127.0.0.1 [7f000001]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -VVVV '<a@cname2cname1.sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} > ${IP}
cat > ${OK} <<EOF
IP[0]=127.0.0.1 [7f000001]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -VVVV '<a@cnamemx.sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} > ${IP}
cat > ${OK} <<EOF
IP[0]=127.0.0.1 [7f000001]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

# rm -f ${OUT} ${IP} ${OK}

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

exit ${ERRS}
