#!/bin/sh
# $Id: t-access-0.sh,v 1.15 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test access map restrictions for RFC2821 addresses.
# Uses smar, t-access-0, access map, t-mm, startsmar.sh
# ------------------------------------------------------------
# Note: smar and t-access-0 are running asynchronous, hence
# there must be no expected order in the output file.
#
# don't run if stop is "set".
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=access-0.out
IP=access-0.ip
OK=access-0.ok
TPRG=./t-access-0
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${ACCMAP} ${SOCK} ${PIDS}

# create access map for tests
${VALGRIND} ${MM} -t'	' -F ${ACCMAP} <<EOF
from:a@b.c	error:550 5.7.0 no from:a@b.c
from:@x.y	error:551 5.7.1 no from:@x.y
from:@.z	error:552 5.7.2 no from:@.z
from:local	error:553 5.7.3 no from:local
from:d*@b.c	error:550 5.7.4 no from:d*@b.c
EOF

killit()
{
if test -s ${PIDS}
then
  # stop SMAR
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
exit 1
}
trap killit 2


# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} '<a@b.c>' '<a+det@b.c>' '<a+@b.c>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='550 5.7.0 no from:a@b.c
react=no_match
react=no_match
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} '<d@b.c>' '<d+det@b.c>' '<d+@b.c>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='550 5.7.4 no from:d*@b.c
react=statt, ret=0, statt='550 5.7.4 no from:d*@b.c
react=statt, ret=0, statt='550 5.7.4 no from:d*@b.c
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} '<no@b.c>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=no_match
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} '<test2@x.y>' '<test2+det@x.y>' '<test2+@x.y>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='551 5.7.1 no from:@x.y
react=statt, ret=0, statt='551 5.7.1 no from:@x.y
react=statt, ret=0, statt='551 5.7.1 no from:@x.y
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=5
# ----------------------------------------
${VALGRIND} ${TPRG} '<test2@a.x.y>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=no_match
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=6
# ----------------------------------------
${VALGRIND} ${TPRG} '<test3@x.z>' '<test3@a.x.z>' '<test3@xcd.z>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='552 5.7.2 no from:@.z
react=statt, ret=0, statt='552 5.7.2 no from:@.z
react=statt, ret=0, statt='552 5.7.2 no from:@.z
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=7
# ----------------------------------------
${VALGRIND} ${TPRG} '<test3@z.zz>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=no_match
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=8
# ----------------------------------------
${VALGRIND} ${TPRG}  '<local@test4.dom>' '<local+ext@test4.dom>' '<local+@test4.dom>' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='553 5.7.3 no from:local
react=no_match
react=no_match
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
sleep 3

exit ${ERRS}
