/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

/*
**  Test recipient id handling
**  This is an incomplete test!
*/

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-rcptid-0.c,v 1.4 2005/09/26 23:43:32 ca Exp $")

#include "sm/assert.h"
#include "sm/heap.h"
#include "sm/string.h"
#include "sm/io.h"
#include "sm/mta.h"

#include "sm/test.h"
#include <stdio.h>

static int Verbose = 0;

static int
tstrcptid(sessta_id_T ta_id1, int lim)
{
	sm_ret_T ret;
	int r;
	uint j;
	rcpt_id_T rcpt_id;
	rcpt_idx_T rcpt_idx1, rcpt_idx2;
	sessta_id_T ta_id2;
	rcpt_idx_T rcpt_idxs[] =
		{
		0, 1, 16, 31, 32, 63, 64, 127, 128, 255, 256
		, 1023, 1024, 4095, 4096
		, 0x07FFFFFF, 0x0FFFFFFF, 0x08000000, 0x08000001
		, 0x17FFFFFF, 0x1FFFFFFF, 0x18000000, 0x18000001
		, 0x27FFFFFF, 0x2FFFFFFF, 0x28000000, 0x28000001
		, 0x37FFFFFF, 0x3FFFFFFF, 0x38000000, 0x38000001
		, 0x57FFFFFF, 0x5FFFFFFF, 0x58000000, 0x58000001
		, 0xA7FFFFFF, 0xAFFFFFFF, 0xA8000000, 0xA8000001
		, 0xE7FFFFFF, 0xEFFFFFFF, 0xE8000000, 0xE8000001
		, 0x7FFFFFFF, 0xFFFFFFFF
		};

	ret = SM_SUCCESS;
	for (j = 0; j < SM_ARRAY_SIZE(rcpt_idxs); j++)
	{
		/* generate RCPT id */
		rcpt_idx1 = rcpt_idxs[j];
		r = sm_snprintf(rcpt_id, sizeof(rcpt_id), SMTP_RCPTID_FORMAT,
			ta_id1, rcpt_idx1);
		SM_TEST(r != -1);

		/* extract TA id and check */
		RCPTID2SESSTAID(rcpt_id, ta_id2);
		SM_TEST(sm_streq(ta_id1, ta_id2));

		/* extract RCPT idx and check */
		r = RCPTID2IDX(rcpt_id, rcpt_idx2);
		SM_TEST(r == 1);
		SM_TEST(rcpt_idx1 == rcpt_idx2);
	}

	for (rcpt_idx1 = 33; rcpt_idx1 < lim; rcpt_idx1++)
	{
		r = sm_snprintf(rcpt_id, sizeof(rcpt_id), SMTP_RCPTID_FORMAT,
			ta_id1, rcpt_idx1);
		SM_TEST(r != -1);

		/* extract TA id and check */
		RCPTID2SESSTAID(rcpt_id, ta_id2);
		SM_TEST(sm_streq(ta_id1, ta_id2));

		/* extract RCPT idx and check */
		r = RCPTID2IDX(rcpt_id, rcpt_idx2);
		SM_TEST(r == 1);
		SM_TEST(rcpt_idx1 == rcpt_idx2);
		if (rcpt_idx1 != rcpt_idx2 && Verbose)
			sm_io_fprintf(smioerr,
				"rcpt_id=%s, idx1=%d, idx2=%d\n",
				rcpt_id, rcpt_idx1, rcpt_idx2);
	}

	return ret;
}

static int
testrcptid(int lim)
{
	sm_ret_T ret;
	int r;
	sessta_id_T ta_id1;
	int smtpsid;
	id_count_T idc;

	ret = SM_SUCCESS;
	smtpsid = 1;
	idc = 7;

	/* generate TA id */
	r = sm_snprintf(ta_id1, SMTP_STID_SIZE, SMTPS_STID_FORMAT,
			idc, smtpsid);
	SM_TEST(r != -1);

	ret = tstrcptid(ta_id1, lim);

	return ret;
}

int
main(int argc, char **argv)
{
	int c, lim;

	lim = 1024;
	while ((c = getopt(argc, argv, "l:V")) != -1)
	{
		switch (c)
		{
		  case 'l':
			lim = strtoul(optarg, NULL, 0);
			break;
		  case 'V':
			++Verbose;
			break;
		  default:
			break;
		}
	}
	sm_test_begin(argc, argv, "test rcptid-0");
	argc -= optind;
	argv += optind;

	(void) testrcptid(lim);

	return sm_test_end();
}
